package eva.replacer.config;

import eva.replacer.RePlacerClient;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.RelPos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;

import static eva.replacer.config.JsonConfigHelper.*;

public class RePlacerConfig {
    static int ver = 0;
    private final int v = ver;
    private boolean rotateFace = true;
    private boolean rotatePlace = true;

    private static List<String> names =  new ArrayList<>();
    public static Boolean isServer;
    public static int selection = 0;
    public static boolean reCording = false;
    static String buildName;
    private static List<RelPos> tempBuild;
    private static RePlacerConfig INSTANCE;
    private static class_2350 placeDir;
    private static class_2350 faceDir;
    static boolean isHollow = false;
    public static boolean deny = false;

    public static RePlacerConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RePlacerConfig();
        }
        return INSTANCE;
    }

    void updateConfigs(@NotNull RePlacerConfig config) {
        this.rotateFace = config.rotateFace;
        this.rotatePlace = config.rotatePlace;
    }

    public static boolean isRotateFace() {
        return getInstance().rotateFace;
    }

    static void setRotateFace(boolean rotate) {
        getInstance().rotateFace = rotate;
    }

    public static boolean isRotatePlace() {
        return getInstance().rotatePlace;
    }

    static void setRotatePlace(boolean rotate) {
        getInstance().rotatePlace = rotate;
    }

    public static List<String> getNames() {return names;}

    static void setNames(List<String> newNames) {names = newNames;}


    public static boolean isServer() {return isServer;}


    public static @Nullable BuildHolder getBuild() {
        try {
            BuildHolder build = readBuild(names.get(selection));
            if (build.sort()) writeBuild(names.get(selection), build);
            return build;
        } catch (Exception e) {
            writeSquare();
            return null;
        }
    }

    public static void saveBuild() {
        if (!deny) {
            try {
                if (isHollow) tempBuild.removeFirst();
                writeBuild(buildName, new BuildHolder(placeDir, faceDir, tempBuild.toArray(new RelPos[0])));
                RePlacerClient.LOGGER.info("Saved {}!", buildName);
                names.add(buildName);
            } catch (NullPointerException e) {
                RePlacerClient.LOGGER.warn("Could not save build! Build was likely empty!");
            }
        }
        buildName = null;
        tempBuild = null;
        reCording = false;
        placeDir = null;
        faceDir = null;
        isHollow = false;
        deny = false;
        RePlacerClient.LOGGER.info("Purged temp vars");
        writeToConfig();
    }

    static void buildDeleter(@NotNull List<String> list) {
        List<String> list2 = new ArrayList<>(list);
        list.forEach(name -> {
             try {
                 pullBuild(name);
             } catch (FileNotFoundException e) {
                 list2.remove(name);
             }
        });
        names.forEach(name -> {
            if (!list2.contains(name)) {
                deleteBuild(name);
            }
        });
        names = list2;
        selection = 0;
    }

    public static boolean buildSaver(@NotNull class_1750 context) {
        class_2338 pos = context.method_8037();
        boolean disp = false;
        if (tempBuild == null) {
            placeDir = context.method_8038();
            assert context.method_8036() != null;
            class_243 v0 = context.method_8036().method_5720();
            double[] v1 = {v0.field_1352, v0.field_1351, v0.field_1350};
            v1[placeDir.method_10166().ordinal()] = 0.0;
            faceDir = class_2350.method_58251(new class_243(v1[0], v1[1], v1[2]).method_1029());
            tempBuild = new ArrayList<>();
            RelPos.setBase(pos);
            disp = true;
        }
        RelPos rel = new RelPos(pos);
        final boolean[] containerCheck = {true};
        tempBuild.forEach(r -> {
            if (r.equals(rel)) containerCheck[0] = false;
        });
        if (containerCheck[0]) tempBuild.add(rel);
        return disp;
    }

    @Contract(value = " -> new", pure = true)
    public static @NotNull BuildHolder buildDefault() {
        return new BuildHolder(
                class_2350.field_11036,
                class_2350.field_11043,
                new RelPos(0, 0, 0),
                new RelPos(0, 0, 1),
                new RelPos(0, 0, -1),
                new RelPos(1, 0, 0),
                new RelPos(1, 0, 1),
                new RelPos(1, 0, -1),
                new RelPos(-1, 0, 0),
                new RelPos(-1, 0, 1),
                new RelPos(-1, 0, -1)
        );
    }
}
