package eva.replacer.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import eva.replacer.RePlacerClient;
import eva.replacer.mixin.client.access.BlockHitResultAccess;
import eva.replacer.mixin.client.access.MultiPlayerGameModeInvoker;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.BuildInProgress;
import eva.replacer.util.RelPos;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_2561;
import net.minecraft.class_2885;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_7204;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static eva.replacer.RePlacerClient.isHeldOrToggled;
import static eva.replacer.config.JsonConfigHelper.writeSquare;
import static eva.replacer.config.RePlacerConfig.*;
import static eva.replacer.config.RePlacerConfig.buildSaver;
import static eva.replacer.util.BuildHolder.setBaseDir;
import static eva.replacer.util.BuildHolder.setFacing;
import static eva.replacer.util.BuildInProgress.*;
import static eva.replacer.util.RelPos.origin;

@Environment(EnvType.CLIENT)
@Mixin(class_636.class)
public abstract class MultiPlayerGameModeMixin {
    @Final @Shadow @NotNull private class_310 minecraft;
    @Unique @NotNull private final class_636 gameMode = (class_636) (Object) this;
    @Unique private class_746 player;
    @Unique private int waiter;

    @Inject(
            method = "tick",
            at = @At("HEAD")
    )
    private void placeAgain(CallbackInfo ci) {
        assert minecraft.field_1724 != null;
        if (player == null) player = minecraft.field_1724;
        if (rePlacing()) {
            if ((!isServer() || isReadyForBlock()) && player.method_5998(context().method_20287()).method_7909() instanceof class_1747 item) {
                if (!BuildInProgress.isEmpty()) {
                    waiter = 0;
                    RelPos pos = next();
                    if (player.method_56093(pos.pos(), player.method_55754() + 1)) {
                        class_3965 result = BuildInProgress.place(pos, null, context().method_8036(), item);
                        if (!((BlockHitResultAccess) result).isMiss()) {
                            ((MultiPlayerGameModeInvoker) gameMode).invokeStartPrediction(minecraft.field_1687, i -> new class_2885(context().method_20287(), result, i));
                            setReadyForBlock(false);
                        } else {
                            player.method_37908().method_8408(pos.pos(), item.method_7711());
                        }
                    }
                    return;
                } else if (!isClear()) BuildInProgress.clear();
                rePlacing(false);
            } else {
                if (waiter >= 5) {
                    if (!isClear()) BuildInProgress.clear();
                    rePlacing(false);
                    return;
                }
                waiter++;
            }
        }
    }

    @Redirect(
            method = "useItemOn",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startPrediction(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;)V"
            )
    )
    private void reUseItemOn(
            class_636 instance,
            class_638 level,
            class_7204 action,
            @Local MutableObject<class_1269> mutableObject,
            @Local(argsOnly = true) class_1268 hand,
            @Local(argsOnly = true) class_3965 result
    ) {

        if (!(player.method_5998(hand).method_7909() instanceof class_1747 blit) || reCording || rePlacing() || !isHeldOrToggled()) {
            ((MultiPlayerGameModeInvoker) gameMode).invokeStartPrediction(this.minecraft.field_1687, i -> {
                mutableObject.setValue(((MultiPlayerGameModeInvoker) gameMode).invokePerformUseItemOn(player, hand, result));
                return new class_2885(hand, result, i);
            });
            if (mutableObject.getValue() instanceof class_1269.class_9860 && reCording) {
                class_1750 context = new class_1750(
                        player,
                        hand,
                        player.method_5998(hand),
                        result
                );
                if (buildSaver(context)) {
                    assert context.method_8036() != null;
                    context.method_8036().method_7353(class_2561.method_43470("Central block saved!"), true);
                }
            }
        } else {
            class_1750 context = new class_1750(
                    player,
                    hand,
                    player.method_5998(hand),
                    result
            );
            BuildHolder holder = getBuild();
            if (holder == null) {
                RePlacerClient.LOGGER.info("Failed to get build!");
                player.method_7353(class_2561.method_43470("Failed to get build!"), true);
                player.method_7353(class_2561.method_43470("Writing default build."), false);
                writeSquare();
                return;
            }
            rePlacing(true);
            RelPos.setBase(context.method_17698(), context.method_8037());
            try {
                if (origin.equals(new RelPos(holder.x()[0], holder.y()[0], holder.z()[0])))
                    ((MultiPlayerGameModeInvoker) gameMode).invokeStartPrediction(this.minecraft.field_1687, i -> {
                        mutableObject.setValue(((MultiPlayerGameModeInvoker) gameMode).invokePerformUseItemOn(player, hand, result));
                        return new class_2885(hand, result, i);
                    });
                else {
                    player.method_6104(hand);
                    mutableObject.setValue(class_1269.field_5812);
                }
                if (!(mutableObject.getValue() == null) && !(mutableObject.getValue() instanceof class_1269.class_9860)) {
                    rePlacing(false);
                    return;
                }
                if (isRotatePlace()) setBaseDir(context.method_8038());
                if (isRotateFace()) setFacing(player.method_5720(), context.method_8038());
//              formerly compat mode
                BuildInProgress.pass(context);
                setReadyForBlock(false);
                holder.rotateEach(BuildInProgress::pass);
            } catch (Exception ignored) {}
        }
    }
}