/*
 * Decompiled with CFR 0.152.
 */
package eva.replacer.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.replacer.RePlacerClient;
import eva.replacer.config.RePlacerConfig;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.RelPos;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Hashtable;
import net.minecraft.class_2350;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static final File buildFolder = new File(folder, "RePlacer Builds");
    private static File rePlacerConfig;
    private static final Hashtable<String, File> builds;
    public static Gson configGson;

    public static void init() {
        JsonConfigHelper.createConfig();
        JsonConfigHelper.readFromConfig();
        JsonConfigHelper.writeToConfig();
        JsonConfigHelper.createBuilds();
        JsonConfigHelper.writeSquare();
    }

    private static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            boolean seemsValid;
            rePlacerConfig = new File(folder, "replacer.json");
            if (rePlacerConfig.exists()) {
                try {
                    String templateConfigJson = Files.readString(Path.of(rePlacerConfig.getPath(), new String[0]));
                    seemsValid = templateConfigJson.trim().startsWith("{\n  \"v\": " + RePlacerConfig.ver + ",");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                seemsValid = true;
            }
            if (!rePlacerConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    RePlacerClient.LOGGER.info("Found invalid config file, creating new config file at './config/replacer.json'.");
                }
                try {
                    rePlacerConfig.createNewFile();
                    String json = configGson.toJson((Object)RePlacerConfig.getInstance());
                    FileWriter writer = new FileWriter(rePlacerConfig);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void readFromConfig() {
        try {
            RePlacerConfig config = (RePlacerConfig)configGson.fromJson((Reader)new FileReader(rePlacerConfig), RePlacerConfig.class);
            RePlacerConfig.getInstance().updateConfigs(config);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static void writeToConfig() {
        try {
            String json = configGson.toJson((Object)RePlacerConfig.getInstance());
            FileWriter writer = new FileWriter(rePlacerConfig, false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void createBuilds() {
        if (!buildFolder.exists()) {
            buildFolder.mkdir();
        }
        if (buildFolder.isDirectory()) {
            Hashtable<String, File> tempBuilds = new Hashtable<String, File>();
            ArrayList<String> names = new ArrayList<String>();
            if (RePlacerConfig.getNames() == null || RePlacerConfig.getNames().isEmpty()) {
                return;
            }
            for (String name : RePlacerConfig.getNames()) {
                boolean seemsValid;
                File file = new File(buildFolder, name + ".json");
                if (file.exists()) {
                    try {
                        String buildJson = Files.readString(Path.of(file.getPath(), new String[0]));
                        seemsValid = buildJson.trim().startsWith("{");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    seemsValid = true;
                }
                if (!seemsValid || !file.exists()) {
                    if (!seemsValid) {
                        RePlacerClient.LOGGER.info("Found invalid build file, purging.");
                    } else {
                        RePlacerClient.LOGGER.info("Found invalid build name, purging.");
                    }
                    file.delete();
                    continue;
                }
                tempBuilds.put(name, file);
                names.add(name);
            }
            builds.putAll(tempBuilds);
            RePlacerConfig.setNames(new ArrayList<String>(builds.keySet()));
        }
    }

    static void deleteBuild(String name) {
        builds.get(name).delete();
        builds.remove(name);
    }

    static void writeBuild(String name, class_2350 dir, RelPos[] build) {
        try {
            builds.put(name, new File(buildFolder, name + ".json"));
            String json = configGson.toJson((Object)new BuildHolder(dir, build));
            FileWriter writer = new FileWriter(builds.get(name), false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeSquare() {
        try {
            configGson.fromJson((Reader)new FileReader(builds.get("square")), BuildHolder.class);
            if (RePlacerConfig.getNames().isEmpty()) {
                ArrayList<String> names = new ArrayList<String>();
                names.add("square");
                RePlacerConfig.setNames(names);
            }
        }
        catch (Exception ignored) {
            try {
                RePlacerClient.LOGGER.info("Writing default build at './config/RePlacerBuilds/square.json'.");
                builds.put("square", new File(buildFolder, "square.json"));
                FileWriter writer = new FileWriter(builds.get("square"), false);
                writer.write(BuildHolder.buildDefault());
                writer.close();
                ArrayList<String> names = new ArrayList<String>();
                names.add("square");
                RePlacerConfig.setNames(names);
            }
            catch (Exception f) {
                throw new RuntimeException(f);
            }
        }
    }

    static BuildHolder readBuild(String name) {
        try {
            return (BuildHolder)configGson.fromJson((Reader)new FileReader(builds.get(name)), BuildHolder.class);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        builds = new Hashtable();
        configGson = new GsonBuilder().setPrettyPrinting().create();
    }
}

