package eva.replacer.mixin.client;

import eva.replacer.config.RePlacerConfig;
import eva.replacer.rendering.BlockHighlightRenderer;
import eva.replacer.util.BuildInProgress;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11658;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_761.class)
public class LevelRendererMixin {
    @Inject(
            method = "renderBlockOutline",
            at = @At("HEAD")
    )
    private void renderInProgressBuild(class_4597.class_4598 bufferSource, class_4587 poseStack, boolean translucent, class_11658 renderState, CallbackInfo ci) {
        if (RePlacerConfig.isReCording() || BuildInProgress.rePlacing()) {
            BlockHighlightRenderer.renderRePlacerBox(poseStack);
        }
    }

    @Inject(
            method = "renderBlockOutline",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/renderer/state/BlockOutlineRenderState;highContrast()Z"
            ),
            cancellable = true
    )
    private void renderBoxes(class_4597.class_4598 bufferSource, class_4587 poseStack, boolean bl, class_11658 levelRenderState, CallbackInfo ci) {
        if (RePlacerConfig.isReCording() || BuildInProgress.rePlacing()) return;
        if (!BlockHighlightRenderer.renderRePlacerBox(poseStack))
            ci.cancel();
    }
}
