package eva.replacer.network;

import eva.replacer.util.BuildHolder;
import eva.replacer.util.RelPos;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record BuildPacket(BuildHolder build) implements class_8710 {

    private BuildPacket(byte[] vals) {
        this(read(vals));
    }

    public static final class_8710.class_9154<BuildPacket> TYPE = class_8710.method_56483("eva.build");

    public static final class_9139<class_2540, BuildPacket> CODEC = class_9139.method_56434(
            class_9135.field_48987,
            BuildPacket::write,
            BuildPacket::new
    );

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    private byte[] write() {
        byte[] ret = new byte[2 + 3 * build.x().length];
        int len = build.x().length;
        ret[0] = (byte) build.firstDir().ordinal();
        ret[1] = (byte) (build.faceDir() == null ? -1 : build.faceDir().ordinal());
        for (int i = 0; i < len; i++) {
            ret[i + 2] = (byte) build.x()[i];
        }
        for (int i = 0; i < len; i++) {
            ret[i + 2 + len] = (byte) build.y()[i];
        }
        for (int i = 0; i < len; i++) {
            ret[i + 2 + 2 * len] = (byte) build.z()[i];
        }
        return ret;
    }

    private static BuildHolder read(byte[] vals) {
        if ((vals.length - 2) % 3 != 0) throw new IllegalArgumentException();
        int interval = (vals.length - 2) / 3;
        RelPos[] poss = new RelPos[interval];
        for (int i = 2; i < interval + 2; i++) {
            poss[i - 2] = new RelPos(vals[i], vals[i + interval], vals[i + 2 * interval]);
        }
        return new BuildHolder(class_2350.values()[vals[0]], vals[1] < 0 ? null : class_2350.values()[vals[1]], poss);
    }
}
