/*
 * Decompiled with CFR 0.152.
 */
package eva.replacer.util;

import eva.replacer.config.RePlacerConfig;
import eva.replacer.config.SortOrder;
import eva.replacer.util.RelPos;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BuildHolder(class_2350 firstDir, @Nullable class_2350 faceDir, int[] x, int[] y, int[] z) {
    private static class_2350 baseDir;
    private static class_2350 facing;
    private static class_2350 rotCor;

    private BuildHolder(class_2350 firstDir, class_2350 faceDir, int @NotNull [][] tri) {
        this(firstDir, faceDir, tri[0], tri[1], tri[2]);
    }

    public BuildHolder(class_2350 firstDir, class_2350 faceDir, RelPos ... posList) {
        this(firstDir, faceDir, BuildHolder.split(posList));
    }

    public static void setBaseDir(class_2350 baseDir) {
        BuildHolder.baseDir = baseDir;
    }

    public static void setFacing(@NotNull class_243 v0) {
        double[] v1 = new double[]{v0.field_1352, v0.field_1351, v0.field_1350};
        v1[BuildHolder.baseDir.method_10166().ordinal()] = 0.0;
        facing = class_2350.method_58251((class_243)new class_243(v1[0], v1[1], v1[2]));
    }

    RelPos snap(RelPos pos) {
        if (!RePlacerConfig.isSnap() || this.firstDir == baseDir) {
            return pos;
        }
        if (this.firstDir().method_10166() == baseDir.method_10166()) {
            int[] vals = new int[]{pos.vals()[0], pos.vals()[1], pos.vals()[2]};
            int n = this.firstDir().method_10166().ordinal();
            vals[n] = vals[n] * -1;
            return new RelPos(vals);
        }
        int[] ind = new int[]{this.firstDir().method_10166().ordinal(), baseDir.method_10166().ordinal()};
        int[] neg = this.firstDir().method_10171() != baseDir.method_10171() ? new int[]{-1, 1} : new int[]{1, -1};
        int[] vals = new int[3];
        vals[ind[0]] = pos.vals()[ind[1]] * neg[1];
        vals[ind[1]] = pos.vals()[ind[0]] * neg[0];
        vals[3 - ind[0] - ind[1]] = pos.vals()[3 - ind[0] - ind[1]];
        return new RelPos(vals);
    }

    RelPos spin(RelPos pos) {
        if (!RePlacerConfig.isSpin() || this.faceDir == null || pos.equals(RelPos.ORIGIN)) {
            return pos;
        }
        class_2350 rotCor = BuildHolder.rotCor;
        assert (rotCor != null);
        int[] vals = pos.vals();
        class_2350.class_2351 ax = this.firstDir.method_10166();
        RelPos pos2 = pos;
        boolean bl = rotCor.method_10153().equals((Object)this.faceDir);
        if (!rotCor.method_10166().equals((Object)this.faceDir.method_10166())) {
            bl = rotCor.method_35833(ax) != this.faceDir;
            switch (ax) {
                default: {
                    throw new MatchException(null, null);
                }
                case field_11048: {
                    RelPos relPos = new RelPos(vals[0], -vals[2], vals[1]);
                    break;
                }
                case field_11052: {
                    RelPos relPos = new RelPos(vals[2], vals[1], -vals[0]);
                    break;
                }
                case field_11051: {
                    RelPos relPos = pos2 = new RelPos(-vals[1], vals[0], vals[2]);
                }
            }
        }
        if (!bl) {
            return pos2;
        }
        int[] vals2 = pos2.vals();
        return switch (ax) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> new RelPos(vals2[0], -vals2[1], -vals2[2]);
            case class_2350.class_2351.field_11052 -> new RelPos(-vals2[0], vals2[1], -vals2[2]);
            case class_2350.class_2351.field_11051 -> new RelPos(-vals2[0], -vals2[1], vals2[2]);
        };
    }

    @Nullable
    private class_2350 rot() {
        if (this.faceDir == null) {
            return null;
        }
        if (this.firstDir.method_10166().equals((Object)baseDir.method_10166())) {
            return facing;
        }
        class_2350 tempBase = baseDir;
        class_2350 tempFacing = facing;
        class_2350.class_2351 ax = class_2350.class_2351.values()[3 - this.firstDir.method_10166().ordinal() - baseDir.method_10166().ordinal()];
        while (!tempBase.equals((Object)this.firstDir)) {
            tempBase = tempBase.method_35834(ax);
            tempFacing = tempFacing.method_35834(ax);
        }
        return tempFacing;
    }

    public void rotateEach(Consumer<RelPos> action) {
        rotCor = this.rot();
        for (int i = 0; i < this.x.length; ++i) {
            RelPos pos = this.pos(i);
            if (!RePlacerConfig.isSnap() && !RePlacerConfig.isSpin()) {
                action.accept(pos);
                continue;
            }
            action.accept(this.snap(this.spin(pos)));
        }
        rotCor = null;
    }

    public void forEach(Consumer<RelPos> action) {
        for (int i = 0; i < this.x.length; ++i) {
            action.accept(this.pos(i));
        }
    }

    private RelPos pos(int i) {
        return new RelPos(this.x[i], this.y[i], this.z[i]);
    }

    private static int @NotNull [][] split(RelPos @NotNull [] posList) {
        int[][] ret = new int[3][posList.length];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < posList.length; ++j) {
                ret[i][j] = posList[j].vals()[i];
            }
        }
        return ret;
    }

    public RelPos @NotNull [] posList() {
        this.thrower();
        RelPos[] posList = new RelPos[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            posList[i] = new RelPos(this.x[i], this.y[i], this.z[i]);
        }
        return posList;
    }

    @NotNull
    public BuildHolder handleSort(class_1657 player) {
        return switch (RePlacerConfig.getSortOrder()) {
            default -> throw new MatchException(null, null);
            case SortOrder.Near_block_first, SortOrder.Near_block_last -> this.sort();
            case SortOrder.Near_player_first, SortOrder.Near_player_last -> this.sort(player);
            case SortOrder.Random -> this.random();
            case SortOrder.Top_down, SortOrder.Bottom_up, SortOrder.Linearize -> this.linearize();
        };
    }

    private BuildHolder sort() {
        this.thrower();
        RelPos[] posList = new RelPos[this.x.length];
        Comparator<RelPos> comp = Comparator.comparingDouble(RelPos::dist);
        if (!RePlacerConfig.getSortOrder().equals((Object)SortOrder.Near_block_first)) {
            comp = Collections.reverseOrder(comp);
        }
        this.rewrite(posList, comp);
        return this;
    }

    private BuildHolder sort(class_1657 player) {
        this.thrower();
        RelPos[] posList = this.posList();
        class_243 v = player.method_33571();
        Comparator<RelPos> comp = Comparator.comparingDouble(pos -> pos.dist(v));
        if (!RePlacerConfig.getSortOrder().equals((Object)SortOrder.Near_player_first)) {
            comp = Collections.reverseOrder(comp);
        }
        this.rewrite(posList, comp);
        return this;
    }

    private BuildHolder random() {
        this.thrower();
        RelPos[] posList = this.posList();
        Collections.shuffle(Arrays.asList(posList));
        this.subRewrite(posList);
        return this;
    }

    private BuildHolder linearize() {
        this.thrower();
        RelPos[] posList = this.posList();
        String orders = RePlacerConfig.getLinearize();
        while (!orders.isEmpty()) {
            boolean bl = orders.startsWith("-");
            if (bl) {
                orders = orders.substring(1);
            }
            char c = orders.charAt(0);
            Comparator<RelPos> comp = Comparator.comparingInt(pos -> {
                int[] nArray = pos.vals();
                return nArray[switch (c) {
                    case 'x' -> 0;
                    case 'y' -> 1;
                    case 'z' -> 2;
                    default -> throw new IllegalArgumentException();
                }];
            });
            if (bl) {
                comp = Collections.reverseOrder(comp);
            }
            Arrays.sort(posList, comp);
            orders = orders.substring(1);
        }
        this.subRewrite(posList);
        return this;
    }

    private void rewrite(RelPos[] posList, Comparator<RelPos> comp) {
        Arrays.sort(posList, comp);
        this.subRewrite(posList);
    }

    private void subRewrite(RelPos[] posList) {
        for (int i = 0; i < posList.length; ++i) {
            this.x[i] = posList[i].vals()[0];
            this.y[i] = posList[i].vals()[1];
            this.z[i] = posList[i].vals()[2];
        }
    }

    private void thrower() {
        if (this.x.length != this.y.length || this.z.length != this.x.length) {
            throw new IllegalArgumentException();
        }
    }

    public boolean containsOrigin() {
        for (RelPos pos : this.posList()) {
            if (!pos.equals(RelPos.ORIGIN)) continue;
            return true;
        }
        return false;
    }

    static void clear() {
        baseDir = null;
        facing = null;
    }

    @NotNull
    private static List<class_2350> plane(@NotNull class_2350 axDir, class_2350 first) {
        if (axDir.method_10171().equals((Object)class_2350.class_2352.field_11060)) {
            return Arrays.asList(first, first.method_35834(axDir.method_10166()), first.method_10153(), first.method_35833(axDir.method_10166()));
        }
        return Arrays.asList(first, first.method_35833(axDir.method_10166()), first.method_10153(), first.method_35834(axDir.method_10166()));
    }
}

