package eva.replacer.config;

import eva.replacer.RePlacerClient;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.RelPos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.FileNotFoundException;
import java.util.*;
import java.util.function.Function;
import net.minecraft.class_1750;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;

import static eva.replacer.RePlacerClient.getQuickAccess;
import static eva.replacer.config.JsonConfigHelper.*;

public class RePlacerConfig {
    static final int ver = 0;
    private final int v = ver;
    private boolean rotateFace = true;
    private boolean rotatePlace = true;
    private boolean inclTail = false;

    private static List<String> names =  new ArrayList<>();
    private static final List<String> taillessNames = new ArrayList<>();
    public static Boolean isServer;
    public static int selection = 0;
    public static boolean reCording = false;
    static String buildName;
    private static List<RelPos> tempBuild;
    private static RePlacerConfig INSTANCE;
    private static class_2350 placeDir;
    private static class_2350 faceDir;
    static boolean isHollow = false;
    public static boolean deny = false;
    private static final Map<Integer, String> quickAccess = new HashMap<>();

    static final String SPIN = "s";
    static final String SNAP = "f";
    static final String NO = "n";
    static final String DIV = "--";
    static final String REGEX = "[" + SPIN + SNAP + NO + "]";
    static final String REGEXNUM = "[1-9]";

    public static RePlacerConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RePlacerConfig();
        }
        return INSTANCE;
    }

    void updateConfigs(@NotNull RePlacerConfig config) {
        this.rotateFace = config.rotateFace;
        this.rotatePlace = config.rotatePlace;
    }

    public static boolean isSpin() {
        if (names.isEmpty()) return false;
        if (!hasTail(names.get(selection)) || (!tail(names.get(selection)).contains(NO) && !tail(names.get(selection)).contains(SPIN))) return getInstance().rotateFace;
        return tail(names.get(selection)).contains(SPIN);
    }

    static boolean spin() {
        return getInstance().rotateFace;
    }

    static void setSpin(boolean rotate) {
        getInstance().rotateFace = rotate;
    }

    public static boolean isSnap() {
        if (names.isEmpty()) return false;
        if (!hasTail(names.get(selection)) || (!tail(names.get(selection)).contains(NO) && !tail(names.get(selection)).contains(SNAP))) return getInstance().rotatePlace;
        return tail(names.get(selection)).contains(SNAP);
    }

    static boolean snap() {
        return getInstance().rotatePlace;
    }

    static void setSnap(boolean rotate) {
        getInstance().rotatePlace = rotate;
    }

    public static List<String> getNames() {
        return new ArrayList<>(names);
    }

    static List<String> getTaillessNames() {
        return taillessNames;
    }

    static void setNames(List<String> newNames) {
        names = new ArrayList<>(newNames);
        taillessNames.clear();
        for (String name : newNames) {
            if (parseAccess(name) != -1) quickAccess.put(parseAccess(name), name);
            taillessNames.add(removeTail(name));
        }
    }

    public static boolean isServer() {return isServer;}

    public static boolean isInclTail() {
        return getInstance().inclTail;
    }

    static void setInclTail(boolean inclTail) {
        getInstance().inclTail = inclTail;
    }

    public static @Nullable BuildHolder getBuild() {
        try {
            BuildHolder build =  readBuild(names.get(selection));
            if (build.sort()) writeBuild(names.get(selection), build);
            return build;
        } catch (Exception e) {
            if (e instanceof IndexOutOfBoundsException) return null;
            writeSquare();
            return null;
        }
    }

    public static @Nullable BuildHolder getQuickBuild() {
        try {
            return readBuild(quickAccess.get(getQuickAccess()));
        } catch (NullPointerException e) {
            return null;
        }
    }

    public static void saveBuild() {
        if (!deny && class_310.method_1551().field_1724 != null) {
            try {
                if (isHollow) tempBuild.removeFirst();
                writeBuild(buildName, new BuildHolder(placeDir, faceDir, tempBuild.toArray(new RelPos[0])));
                RePlacerClient.LOGGER.info("Saved {}!", tailless(buildName));
                List<String> temp = names;
                temp.add(buildName);
                setNames(temp);
            } catch (Exception e) {
                if (e instanceof NullPointerException) RePlacerClient.LOGGER.warn("Could not save build! Build was likely empty!");
                else RePlacerClient.LOGGER.warn("Could not save build! Build name wass likely empty!");
            }
        }
        buildName = null;
        tempBuild = null;
        reCording = false;
        placeDir = null;
        faceDir = null;
        isHollow = false;
        deny = false;
        RePlacerClient.LOGGER.info("Purged temp vars");
        writeToConfig();
    }

    static void buildDeleter(@NotNull List<String> list) {
        if (list.equals(names)) return;
        List<String> list2 = new ArrayList<>(list);
        list.forEach(build -> {
             try {
                 if (build.contains(DIV)) {
                     String tail = tail(build);
                     String name = build.substring(0, build.indexOf(DIV));
                     int ind = names.contains(name) ? names.indexOf(name) : getTaillessNames().indexOf(name);
                     String oldName = names.get(ind);
                     if (!tail.isEmpty()) {
                         renameBuild(oldName, name + DIV + tail);
                     } else {
                         pullBuild(oldName);
                         list2.remove(build);
                         list2.add(oldName);
                     }
                 } else pullBuild(build);
             } catch (FileNotFoundException e) {
                 list2.remove(build);
             }
        });
        names.forEach(name -> {
            if (!list2.contains(name)) {
                deleteBuild(name);
            }
        });
        setNames(list2);
        if (selection > names.size()) selection = names.size();
    }

    public static boolean buildSaver(@NotNull class_1750 context) {
        class_2338 pos = context.method_8037();
        boolean disp = false;
        if (tempBuild == null) {
            placeDir = context.method_8038();
            assert context.method_8036() != null;
            class_243 v0 = context.method_8036().method_5720();
            double[] v1 = {v0.field_1352, v0.field_1351, v0.field_1350};
            v1[placeDir.method_10166().ordinal()] = 0.0;
            faceDir = class_2350.method_58251(new class_243(v1[0], v1[1], v1[2]).method_1029());
            tempBuild = new ArrayList<>();
            RelPos.setBase(pos);
            disp = true;
        }
        RelPos rel = new RelPos(pos);
        final boolean[] containerCheck = {true};
        tempBuild.forEach(r -> {
            if (r.equals(rel)) containerCheck[0] = false;
        });
        if (containerCheck[0]) tempBuild.add(rel);
        return disp;
    }

    static boolean isValidTail(String tail) {
        if (!tail.trim().equals(tail)) return false;
        tail = tail.toLowerCase();
        if (tail.isEmpty() || tail.length() > 3) return false;
        if (!tail.replaceAll(REGEX, "").replaceAll(REGEXNUM, "").isEmpty()) return false;
        tail = tail.replaceAll(REGEXNUM, "");
        if (tail.length() <= 1) return true;
        if (tail.replaceAll(SNAP,"").isEmpty()) return false;
        if (tail.replaceAll(SPIN, "").isEmpty()) return false;
        if (tail.replaceAll(NO, "").isEmpty()) return false;
        return true;
    }

    static boolean hasTail(String build) {
        if (!build.contains(DIV)) return false;
        if (tail(build).isEmpty()) return true;
        return isValidTail(tail(build));
    }

    static String tail(String build) {
        String tail = build.substring(build.indexOf(DIV) + 2).trim();
        switch (tail) {
            case NO + NO -> {
                return NO;
            }
            case SPIN + SPIN -> {
                return SPIN;
            }
            case SNAP + SNAP -> {
                return SNAP;
            }
        }
        if (isValidTail(tail)) return tail;
        return "";
    }

    public static String tailless(String build) {
        if (isInclTail() || !hasTail(build)) return build;
        return removeTail(build);
    }

    static String removeTail(String build) {
        if (!hasTail(build)) return build;
        return build.substring(0, build.indexOf(DIV));
    }

    static int parseAccess(String name) {
        if (!hasTail(name) || !isValidTail(tail(name))) return -1;
        String remainder = tail(name).replaceAll(REGEX, "");
        if (remainder.isEmpty()) return -1;
        return Integer.parseInt(remainder) - 1;
    }

    public static boolean hasQuickAccess(int slot) {
        return quickAccess.containsKey(slot);
    }

    static void startReCording(boolean val) {
        if (class_310.method_1551().field_1724 == null) return;
        reCording = val;
    }

    @Contract(value = " -> new", pure = true)
    public static @NotNull BuildHolder buildDefault() {
        return new BuildHolder(
                class_2350.field_11036,
                class_2350.field_11043,
                new RelPos(0, 0, 0),
                new RelPos(0, 0, 1),
                new RelPos(0, 0, -1),
                new RelPos(1, 0, 0),
                new RelPos(1, 0, 1),
                new RelPos(1, 0, -1),
                new RelPos(-1, 0, 0),
                new RelPos(-1, 0, 1),
                new RelPos(-1, 0, -1)
        );
    }

    static CellErrorSupplier getCellErrorSupplier() {
        return new CellErrorSupplier();
    }

    private static class CellErrorSupplier implements Function<String, Optional<class_2561>> {
        @Override
        public Optional<class_2561> apply(String entry) {
            entry = entry.toLowerCase();
            if (entry.indexOf(DIV) != entry.lastIndexOf(DIV))
                return Optional.of(class_2561.method_43470("You cannot have more than one modifier tail! error code: 0"));
            if (!hasTail(entry) || isValidTail(tail(entry))) return Optional.empty();
            else {
                if (tail(entry).isEmpty()) return Optional.of(class_2561.method_43470("Tail is empty! error code: 1"));
                return Optional.of(class_2561.method_43470("Invalid tail! error code: 2"));
            }
        }
    }

    static NameErrorSupplier getNameErrorSupplier() {
        return new NameErrorSupplier();
    }

    private static class NameErrorSupplier implements Function<String, Optional<class_2561>> {
        @Override
        public Optional<class_2561> apply(String entry) {
            if (!hasTail(entry) || isValidTail(tail(entry))) {
                if (getTaillessNames().contains(removeTail(entry))) return Optional.of(class_2561.method_43470("Duplicate name! error code: 6"));
                return Optional.empty();
            }
            return Optional.of(class_2561.method_43470("Invalid tail! error code: 7"));
        }
    }

    static ErrorSupplier getErrorSupplier() {
        return new ErrorSupplier();
    }

    private static class ErrorSupplier implements Function<List<String>, Optional<class_2561>> {
        @Override
        public Optional<class_2561> apply(List<String> entry) {
            if (entry.isEmpty()) return Optional.empty();
            Set<Integer> quickInts = new HashSet<>();
            Set<String> taillessNames = new HashSet<>(getTaillessNames());
            Set<String> names = new HashSet<>();
            for (String build : entry) {
                String tailless = removeTail(build);
                if (names.contains(tailless)) return Optional.of(class_2561.method_43470("Duplicate build name! error code: 3"));
                if (!taillessNames.contains(tailless)) return Optional.of(class_2561.method_43470("You cannot add builds or change their names here! error code: 4"));
                names.add(tailless);
                if (hasTail(build)) {
                    String tail = tail(build);
                    if (!tail.replaceAll(REGEX, "").isEmpty()) {
                        int i = Integer.parseInt(tail);
                        if (!quickInts.add(i)) return Optional.of(class_2561.method_43470("Each build can have a max of one quickaccess number! error code: 5"));
                    }
                }
            }
            return Optional.empty();
        }
    }
}
