package eva.replacer.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import static eva.replacer.RePlacerClient.isHoldingEither;
import static eva.replacer.RePlacerClient.setQuickAccess;
import static eva.replacer.config.RePlacerConfig.hasQuickAccess;

import net.minecraft.class_1661;
import net.minecraft.class_310;

@Mixin(class_310.class)
public class MinecraftMixin {
    @Redirect(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;setSelectedSlot(I)V"
            )
    )
    private void quickAccessBuilds(class_1661 instance, int slot) {
        if (isHoldingEither() && hasQuickAccess(slot)) setQuickAccess(slot);
        else instance.method_61496(slot);
    }
}
