package eva.replacer.util;

import static eva.replacer.config.RePlacerConfig.isRotate;

import net.minecraft.class_2350;

public record BuildHolder(class_2350 firstDir, RelPos[] posList) {
    private static class_2350 baseDir;
    public static void setBaseDir(class_2350 baseDir) {
        BuildHolder.baseDir = baseDir;
    }
    public static BuildHolder rotate(BuildHolder holder) {
        RelPos[] posList = holder.posList();
        if (!isRotate() || holder.firstDir() == baseDir)
            return holder;
        if (holder.firstDir().method_10166() == baseDir.method_10166()) {
            for (int i = 0; i < posList.length; ++i) {
                int[] vals = posList[i].vals();
                vals[holder.firstDir().method_10166().ordinal()] *= -1;
                posList[i] = new RelPos(vals);
            }
            return new BuildHolder(holder.firstDir(), posList);
        }
        int[] ind = {holder.firstDir().method_10166().ordinal(), baseDir.method_10166().ordinal()};
        int[] neg;
        if (holder.firstDir().method_10171() == baseDir.method_10171())
            neg = new int[]{-1, 1};
        else
            neg = new int[]{1, -1};
        for (int i = 0; i < posList.length; ++i) {
            int[] vals = new int[3];
            vals[ind[0]] = posList[i].vals()[ind[1]] * neg[1];
            vals[ind[1]] = posList[i].vals()[ind[0]] * neg[0];
            vals[3 - ind[0] - ind[1]] = posList[i].vals()[3 - ind[0] - ind[1]];
            posList[i] = new RelPos(vals);
        }
        return new BuildHolder(baseDir, posList);
    }

    public static String buildDefault() {
        return "{\n" +
                "  \"firstDir\": \"UP\",\n" +
                "  \"posList\": [\n" +
                "    {\n" +
                "      \"pos\": [\n" +
                "        0,\n" +
                "        0,\n" +
                "        0\n" +
                "      ]\n" +
                "    },\n" +
                "    {\n" +
                "      \"pos\": [\n" +
                "        1,\n" +
                "        0,\n" +
                "        0\n" +
                "      ]\n" +
                "    },\n" +
                "    {\n" +
                "      \"pos\": [\n" +
                "        -1,\n" +
                "        0,\n" +
                "        0\n" +
                "      ]\n" +
                "    },\n" +
                "    {\n" +
                "      \"pos\": [\n" +
                "        0,\n" +
                "        0,\n" +
                "        1\n" +
                "      ]\n" +
                "    },\n" +
                "    {\n" +
                "      \"pos\": [\n" +
                "        -1,\n" +
                "        0,\n" +
                "        1\n" +
                "      ]\n" +
                "    },\n" +
                "    {\n" +
                "      \"pos\": [\n" +
                "        1,\n" +
                "        0,\n" +
                "        1\n" +
                "      ]\n" +
                "    },\n" +
                "    {\n" +
                "      \"pos\": [\n" +
                "        1,\n" +
                "        0,\n" +
                "        -1\n" +
                "      ]\n" +
                "    },\n" +
                "    {\n" +
                "      \"pos\": [\n" +
                "        0,\n" +
                "        0,\n" +
                "        -1\n" +
                "      ]\n" +
                "    },\n" +
                "    {\n" +
                "      \"pos\": [\n" +
                "        -1,\n" +
                "        0,\n" +
                "        -1\n" +
                "      ]\n" +
                "    }\n" +
                "  ]\n" +
                "}";
    }
}
