package eva.replacer.rendering;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.VertexFormat;
import eva.replacer.config.RePlacerConfig;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.BuildInProgress;
import eva.replacer.util.KeybindHandler;
import eva.replacer.util.RelPos;
import org.joml.Matrix4f;

import java.util.Collection;
import java.util.HashSet;
import java.util.OptionalDouble;
import net.minecraft.class_10799;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2482;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2771;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;

import static eva.replacer.rendering.BoundingBoxMerger.merge;
import static eva.replacer.util.BuildHolder.setFacing;

public class BlockHighlightRenderer {
    private static final class_1921 LINES_NORMAL = class_1921.method_23594();
    private static final RenderPipeline TRANSPARENT_LINES_PIPELINE =
            class_10799.method_67887(RenderPipeline.builder(class_10799.field_60127, class_10799.field_60126)
                    .withVertexShader("core/rendertype_lines")
                    .withFragmentShader("core/rendertype_lines")
                    .withBlend(BlendFunction.TRANSLUCENT)
                    .withCull(false)
                    .withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST)
                    .withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_29344)
                    .withLocation("pipeline/transparent_lines")
                    .build());
    private static final class_1921 LINES_TRANSPARENT = class_1921.method_24048(
            "lines",
            1536, TRANSPARENT_LINES_PIPELINE,
            class_1921.class_4688.method_23598()
                    .method_23609(new class_4668.class_4677(OptionalDouble.empty()))
                    .method_23607(class_1921.field_21352)
                    .method_23610(class_1921.field_25643)
                    .method_23617(false)
    );

    public static boolean renderRePlacerBox(class_4587 poseStack) {
        if (RePlacerConfig.isReCording() && (RePlacerConfig.getTempBuildForRendering() == null || RePlacerConfig.getTempBuildForRendering().isEmpty())) return true;
        class_310 mc = class_310.method_1551();
        class_1937 level = mc.field_1687;
        class_1657 player = mc.field_1724;
        if (level == null || player == null) return true;

        if (!(BuildInProgress.rePlacing() || KeybindHandler.isHeldOrToggled() || RePlacerConfig.isReCording())) return true;

        class_239 result = mc.field_1765;
        if (!(result instanceof class_3965 blockRes)) return true;
        HashSet<class_2338> blocksToHighlight = new HashSet<>();
        HashSet<class_2338> outOfRangeBlocks = new HashSet<>();
        class_2338 origin = blockRes.method_17777();
        if (BuildInProgress.rePlacing()) {
            BuildInProgress.remaining().forEach(pos -> {
                if (player.method_56093(pos.pos(), 1)
                        && level.method_8320(pos.pos()).method_26166(BuildInProgress.context())
                )
                    blocksToHighlight.add(pos.pos());
                else outOfRangeBlocks.add(pos.pos());
            });
        } else if(RePlacerConfig.isReCording()) {
            try {
                RePlacerConfig.getTempBuildForRendering().forEach(pos -> {
                    if (player.method_56093(pos.pos(), 1))
                        blocksToHighlight.add(pos.pos());
                    else outOfRangeBlocks.add(pos.pos());
                });
            } catch (NullPointerException e) {
                return true;
            }
        } else {
            class_1268 hand;
            if (!(
                    player.method_5998(class_1268.field_5808).method_7909() instanceof class_1747)
                    && player.method_5998(class_1268.field_5810).method_7909() instanceof class_1747
            )
                hand = class_1268.field_5810;
            else hand = class_1268.field_5808;
            class_1750 context = new class_1750(player, hand, player.method_5998(hand), blockRes);
            if (!level.method_8320(origin).method_26166(context)
                    || (
                            blockRes.method_17780().method_10166() == class_2350.class_2351.field_11052
                                    && level.method_8320(blockRes.method_17777()) instanceof class_2680 state
                                    && state.method_26204() instanceof class_2482 slock
                                    && state.method_11654(class_2741.field_12485).equals(
                                            switch (blockRes.method_17780()) {
                                                case field_11033 -> class_2771.field_12681;
                                                case field_11036 -> class_2771.field_12679;
                                                default -> class_259.method_1077();
                                            })
                                    && player.method_5998(hand).method_7909() instanceof class_1747 blit
                                    && blit.method_7711() instanceof class_2482 blib
                                    && slock.equals(blib)
            ))
                origin = origin.method_10093(blockRes.method_17780());
            RelPos.setBase(origin);
            if (RePlacerConfig.isSnap()) BuildHolder.setBaseDir(blockRes.method_17780());
            if (RePlacerConfig.isSpin()) setFacing(player.method_5720(), blockRes.method_17780());
            try {
                BuildHolder holder = RePlacerConfig.handleGetBuild();
                assert holder != null;
                holder.rotateEach(ros -> {
                    if (player.method_56093(ros.pos(), 1) && level.method_8320(ros.pos()).method_26166(context))
                            blocksToHighlight.add(ros.pos());
                    else outOfRangeBlocks.add(ros.pos());
                });
            } catch (NullPointerException ignored) {
                return true;
            }
        }

        if (blocksToHighlight.isEmpty()) {
            return true;
        }

        class_4184 renderInfo = mc.field_1773.method_19418();
        class_243 projectedView = renderInfo.method_19326();
        assert poseStack != null;
        poseStack.method_22903();
        poseStack.method_22904(
                origin.method_10263() - projectedView.field_1352,
                origin.method_10264() - projectedView.field_1351,
                origin.method_10260() - projectedView.field_1350
        );
        Matrix4f matrix = poseStack.method_23760().method_23761();

        Collection<class_265> shapes = new HashSet<>();
        for (class_238 aabb : merge(blocksToHighlight.stream().toList(), origin)) {
            shapes.add(class_259.method_1078(aabb.method_1014(0.005d)));
        }
        Collection<class_265> oorShapes = new HashSet<>();
        for (class_238 aabb : merge(outOfRangeBlocks.stream().toList(), origin)) {
            oorShapes.add(class_259.method_1078(aabb.method_1014(0.005d)));
        }

        class_4597.class_4598 buffers = mc.method_22940().method_23000();

        class_4588 vertexBuilder2 = buffers.getBuffer(LINES_TRANSPARENT);

        orShapes(shapes).method_1104((x1, y1, z1, x2, y2, z2) -> {
            final double dx = x2 - x1;
            final double dy = y2 - y1;
            final double dz = z2 - z1;

            final double invMag = 1.0 / Math.sqrt(dx * dx + dy * dy + dz * dz);
            final float nx = (float) (dx * invMag);
            final float ny = (float) (dy * invMag);
            final float nz = (float) (dz * invMag);
            class_4587.class_4665 pose = poseStack.method_23760();
            vertexBuilder2.method_22918(matrix, (float) x1, (float) y1, (float) z1)
                    .method_1336(RePlacerConfig.getTransparentBorderColor().getRed(), RePlacerConfig.getTransparentBorderColor().getGreen(), RePlacerConfig.getTransparentBorderColor().getBlue(), RePlacerConfig.getTransparentBorderColor().getAlpha())
                    .method_60831(pose, nx, ny, nz);
            vertexBuilder2.method_22918(matrix, (float) x2, (float) y2, (float) z2)
                    .method_1336(RePlacerConfig.getTransparentBorderColor().getRed(), RePlacerConfig.getTransparentBorderColor().getGreen(), RePlacerConfig.getTransparentBorderColor().getBlue(), RePlacerConfig.getTransparentBorderColor().getAlpha())
                    .method_60831(pose, nx, ny, nz);
        });
        buffers.method_22994(LINES_TRANSPARENT);

        class_4588 vertexBuilder = buffers.getBuffer(LINES_NORMAL);

        orShapes(shapes).method_1104((x1, y1, z1, x2, y2, z2) -> {
            final double dx = x2 - x1;
            final double dy = y2 - y1;
            final double dz = z2 - z1;

            final double invMag = 1.0 / Math.sqrt(dx * dx + dy * dy + dz * dz);
            final float nx = (float) (dx * invMag);
            final float ny = (float) (dy * invMag);
            final float nz = (float) (dz * invMag);
            class_4587.class_4665 pose = poseStack.method_23760();
            vertexBuilder.method_22918(matrix, (float) x1, (float) y1, (float) z1)
                    .method_1336(RePlacerConfig.getBorderColor().getRed(), RePlacerConfig.getBorderColor().getGreen(), RePlacerConfig.getBorderColor().getBlue(), RePlacerConfig.getBorderColor().getAlpha())
                    .method_60831(pose, nx, ny, nz);
            vertexBuilder.method_22918(matrix, (float) x2, (float) y2, (float) z2)
                    .method_1336(RePlacerConfig.getBorderColor().getRed(), RePlacerConfig.getBorderColor().getGreen(), RePlacerConfig.getBorderColor().getBlue(), RePlacerConfig.getBorderColor().getAlpha())
                    .method_60831(pose, nx, ny, nz);
        });
        buffers.method_22994(LINES_NORMAL);

        class_4588 vertexBuilder4 = buffers.getBuffer(LINES_TRANSPARENT);

        orShapes(oorShapes).method_1104((x1, y1, z1, x2, y2, z2) -> {
            final double dx = x2 - x1;
            final double dy = y2 - y1;
            final double dz = z2 - z1;

            final double invMag = 1.0 / Math.sqrt(dx * dx + dy * dy + dz * dz);
            final float nx = (float) (dx * invMag);
            final float ny = (float) (dy * invMag);
            final float nz = (float) (dz * invMag);
            class_4587.class_4665 pose = poseStack.method_23760();
            vertexBuilder4.method_22918(matrix, (float) x1, (float) y1, (float) z1)
                    .method_1336(RePlacerConfig.getTransparentExcludedColor().getRed(), RePlacerConfig.getTransparentExcludedColor().getGreen(), RePlacerConfig.getTransparentExcludedColor().getBlue(), RePlacerConfig.getTransparentExcludedColor().getAlpha())
                    .method_60831(pose, nx, ny, nz);
            vertexBuilder4.method_22918(matrix, (float) x2, (float) y2, (float) z2)
                    .method_1336(RePlacerConfig.getTransparentExcludedColor().getRed(), RePlacerConfig.getTransparentExcludedColor().getGreen(), RePlacerConfig.getTransparentExcludedColor().getBlue(), RePlacerConfig.getTransparentExcludedColor().getAlpha())
                    .method_60831(pose, nx, ny, nz);
        });
        buffers.method_22994(LINES_TRANSPARENT);

        class_4588 vertexBuilder3 = buffers.getBuffer(LINES_NORMAL);

        orShapes(oorShapes).method_1104((x1, y1, z1, x2, y2, z2) -> {
            final double dx = x2 - x1;
            final double dy = y2 - y1;
            final double dz = z2 - z1;

            final double invMag = 1.0 / Math.sqrt(dx * dx + dy * dy + dz * dz);
            final float nx = (float) (dx * invMag);
            final float ny = (float) (dy * invMag);
            final float nz = (float) (dz * invMag);
            class_4587.class_4665 pose = poseStack.method_23760();
            vertexBuilder3.method_22918(matrix, (float) x1, (float) y1, (float) z1)
                    .method_1336(RePlacerConfig.getExcludedColor().getRed(), RePlacerConfig.getExcludedColor().getGreen(), RePlacerConfig.getExcludedColor().getBlue(), RePlacerConfig.getExcludedColor().getAlpha())
                    .method_60831(pose, nx, ny, nz);
            vertexBuilder3.method_22918(matrix, (float) x2, (float) y2, (float) z2)
                    .method_1336(RePlacerConfig.getExcludedColor().getRed(), RePlacerConfig.getExcludedColor().getGreen(), RePlacerConfig.getExcludedColor().getBlue(), RePlacerConfig.getExcludedColor().getAlpha())
                    .method_60831(pose, nx, ny, nz);
        });
        buffers.method_22994(LINES_NORMAL);

        poseStack.method_22909();
        return false;
    }

    static class_265 orShapes(Collection<class_265> shapes) {
        class_265 combinedShape = class_259.method_1073();
        for (class_265 shape : shapes) {
            combinedShape = class_259.method_1082(combinedShape, shape, class_247.field_1366);
        }
        return combinedShape;
    }
}