/*
 * Decompiled with CFR 0.152.
 */
package eva.replacer.config;

import eva.replacer.RePlacerClient;
import eva.replacer.config.JsonConfigHelper;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.RelPos;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1750;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RePlacerConfig {
    static final int ver = 0;
    private final int v = 0;
    private boolean rotateFace = true;
    private boolean rotatePlace = true;
    private boolean inclTail = false;
    private boolean exclude = false;
    private String defBuild = "";
    private static List<String> names = new ArrayList<String>();
    private static final List<String> taillessNames = new ArrayList<String>();
    public static Boolean isServer;
    static int selection;
    public static boolean reCording;
    static String buildName;
    private static List<RelPos> tempBuild;
    private static RePlacerConfig INSTANCE;
    private static class_2350 placeDir;
    private static class_2350 faceDir;
    static boolean isHollow;
    public static boolean deny;
    private static final Map<Integer, String> quickAccess;
    private static Boolean listSideCombinedErrorChecker;
    private static Boolean boolSideCombinedErrorChecker;
    static final String SPIN = "s";
    static final String SNAP = "f";
    static final String NO = "n";
    static final String DIV = "--";
    static final String REGEX = "[sfn]";
    static final String REGEXNUM = "[1-9]";

    public static RePlacerConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RePlacerConfig();
        }
        return INSTANCE;
    }

    void updateConfigs(@NotNull RePlacerConfig config) {
        this.rotateFace = config.rotateFace;
        this.rotatePlace = config.rotatePlace;
        this.inclTail = config.inclTail;
        this.defBuild = config.defBuild;
        this.exclude = config.exclude;
    }

    public static boolean isSpin() {
        if (names.isEmpty()) {
            return false;
        }
        if (!RePlacerConfig.hasTail(names.get(selection)) || !RePlacerConfig.tail(names.get(selection)).contains(NO) && !RePlacerConfig.tail(names.get(selection)).contains(SPIN)) {
            return RePlacerConfig.getInstance().rotateFace;
        }
        return RePlacerConfig.tail(names.get(selection)).contains(SPIN);
    }

    static boolean spin() {
        return RePlacerConfig.getInstance().rotateFace;
    }

    static void setSpin(boolean rotate) {
        RePlacerConfig.getInstance().rotateFace = rotate;
    }

    public static boolean isSnap() {
        if (names.isEmpty()) {
            return false;
        }
        if (!RePlacerConfig.hasTail(names.get(selection)) || !RePlacerConfig.tail(names.get(selection)).contains(NO) && !RePlacerConfig.tail(names.get(selection)).contains(SNAP)) {
            return RePlacerConfig.getInstance().rotatePlace;
        }
        return RePlacerConfig.tail(names.get(selection)).contains(SNAP);
    }

    static boolean snap() {
        return RePlacerConfig.getInstance().rotatePlace;
    }

    static void setSnap(boolean rotate) {
        RePlacerConfig.getInstance().rotatePlace = rotate;
    }

    public static List<String> getNames() {
        return new ArrayList<String>(names);
    }

    static List<String> getTaillessNames() {
        return taillessNames;
    }

    static void setNames(List<String> newNames) {
        names = new ArrayList<String>(newNames);
        taillessNames.clear();
        for (String name : newNames) {
            if (RePlacerConfig.parseAccess(name) != -1) {
                quickAccess.put(RePlacerConfig.parseAccess(name), name);
                if (quickAccess.size() == names.size()) {
                    RePlacerConfig.setExclude(false);
                }
            }
            taillessNames.add(RePlacerConfig.removeTail(name));
        }
    }

    public static String getDefBuild() {
        return RePlacerConfig.getInstance().defBuild;
    }

    static void setDefBuild(String defBuild) {
        RePlacerConfig.getInstance().defBuild = defBuild;
    }

    public static boolean isServer() {
        return isServer;
    }

    public static boolean isInclTail() {
        return RePlacerConfig.getInstance().inclTail;
    }

    static void setInclTail(boolean inclTail) {
        RePlacerConfig.getInstance().inclTail = inclTail;
    }

    static boolean isExclude() {
        return RePlacerConfig.getInstance().exclude;
    }

    static void setExclude(boolean exclude) {
        RePlacerConfig.getInstance().exclude = exclude;
    }

    public static void cycleSelection(boolean isNeg, int i) {
        if (i > names.size()) {
            return;
        }
        if (isNeg) {
            if (--selection < 0) {
                selection = RePlacerConfig.getNames().size() - 1;
            }
        } else {
            ++selection;
            selection %= RePlacerConfig.getNames().size();
        }
        if (RePlacerConfig.isExclude() && quickAccess.containsValue(names.get(selection))) {
            RePlacerConfig.cycleSelection(isNeg, i + 1);
        }
    }

    public static int getSelection() {
        return selection;
    }

    public static void tareSelection() {
        selection = 0;
    }

    @Nullable
    public static BuildHolder getBuild() {
        try {
            BuildHolder build = JsonConfigHelper.readBuild(names.get(selection));
            if (build.sort()) {
                JsonConfigHelper.writeBuild(names.get(selection), build);
            }
            return build;
        }
        catch (Exception e) {
            if (e instanceof IndexOutOfBoundsException) {
                return null;
            }
            JsonConfigHelper.writeSquare();
            return null;
        }
    }

    @Nullable
    public static BuildHolder getQuickBuild() {
        try {
            return JsonConfigHelper.readBuild(quickAccess.get(RePlacerClient.getQuickAccess()));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static void saveBuild() {
        if (!deny && class_310.method_1551().field_1724 != null) {
            try {
                if (isHollow) {
                    tempBuild.removeFirst();
                }
                JsonConfigHelper.writeBuild(buildName, new BuildHolder(placeDir, faceDir, tempBuild.toArray(new RelPos[0])));
                RePlacerClient.LOGGER.info("Saved {}!", (Object)RePlacerConfig.tailless(buildName));
                List<String> temp = names;
                temp.add(buildName);
                RePlacerConfig.setNames(temp);
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    RePlacerClient.LOGGER.warn("Could not save build! Build was likely empty!");
                }
                RePlacerClient.LOGGER.warn("Could not save build! Build name wass likely empty!");
            }
        }
        buildName = null;
        tempBuild = null;
        reCording = false;
        placeDir = null;
        faceDir = null;
        isHollow = false;
        deny = false;
        RePlacerClient.LOGGER.info("Purged temp vars");
        JsonConfigHelper.writeToConfig();
    }

    static void buildDeleter(@NotNull List<String> list) {
        if (list.equals(names)) {
            return;
        }
        ArrayList<String> list2 = new ArrayList<String>(list);
        list.forEach(build -> {
            try {
                boolean bl;
                boolean bl2 = bl = !taillessNames.contains(RePlacerConfig.removeTail(build));
                if (bl) {
                    JsonConfigHelper.reAddBuild(build);
                }
                if (RePlacerConfig.hasTail(build)) {
                    String oldName;
                    String tail = RePlacerConfig.tail(build);
                    String name = RePlacerConfig.removeTail(build);
                    int ind = names.contains(name) ? names.indexOf(name) : RePlacerConfig.getTaillessNames().indexOf(name);
                    String string = oldName = bl ? JsonConfigHelper.getCachedVer(build) : names.get(ind);
                    if (!tail.isEmpty()) {
                        JsonConfigHelper.renameBuild(oldName, name + DIV + tail);
                    } else {
                        JsonConfigHelper.pullBuild(oldName);
                        list2.remove(build);
                        list2.add(oldName);
                    }
                } else {
                    JsonConfigHelper.pullBuild(build);
                }
            }
            catch (FileNotFoundException e) {
                list2.remove(build);
            }
        });
        names.forEach(name -> {
            if (!list2.contains(name)) {
                JsonConfigHelper.deleteBuild(name);
            }
        });
        RePlacerConfig.setNames(list2);
        if (selection > names.size()) {
            selection = names.size();
        }
    }

    public static boolean buildSaver(@NotNull class_1750 context) {
        class_2338 pos = context.method_8037();
        boolean disp = false;
        if (tempBuild == null) {
            placeDir = context.method_8038();
            assert (context.method_8036() != null);
            class_243 v0 = context.method_8036().method_5720();
            double[] v1 = new double[]{v0.field_1352, v0.field_1351, v0.field_1350};
            v1[RePlacerConfig.placeDir.method_10166().ordinal()] = 0.0;
            faceDir = class_2350.method_58251((class_243)new class_243(v1[0], v1[1], v1[2]).method_1029());
            tempBuild = new ArrayList<RelPos>();
            RelPos.setBase(pos);
            disp = true;
        }
        RelPos rel = new RelPos(pos);
        boolean[] containerCheck = new boolean[]{true};
        tempBuild.forEach(r -> {
            if (r.equals(rel)) {
                containerCheck[0] = false;
            }
        });
        if (containerCheck[0]) {
            tempBuild.add(rel);
        }
        return disp;
    }

    public static void buildRemover(class_2338 pos) {
        RelPos r = new RelPos(pos);
        tempBuild.removeIf(rel -> rel.equals(r));
    }

    static boolean isValidTail(String tail) {
        if (!tail.trim().equals(tail)) {
            return false;
        }
        if ((tail = tail.toLowerCase()).isEmpty() || tail.length() > 3) {
            return false;
        }
        if (!tail.replaceAll(REGEX, "").replaceAll(REGEXNUM, "").isEmpty()) {
            return false;
        }
        if ((tail = tail.replaceAll(REGEXNUM, "")).length() <= 1) {
            return true;
        }
        if (tail.replaceAll(SNAP, "").isEmpty()) {
            return false;
        }
        if (tail.replaceAll(SPIN, "").isEmpty()) {
            return false;
        }
        return !tail.replaceAll(NO, "").isEmpty();
    }

    static boolean hasTail(String build) {
        if (!build.contains(DIV)) {
            return false;
        }
        if (RePlacerConfig.tail(build).isEmpty()) {
            return true;
        }
        return RePlacerConfig.isValidTail(RePlacerConfig.tail(build));
    }

    static String tail(String build) {
        String tail;
        switch (tail = build.substring(build.indexOf(DIV) + 2).trim()) {
            case "nn": {
                return NO;
            }
            case "ss": {
                return SPIN;
            }
            case "ff": {
                return SNAP;
            }
        }
        if (RePlacerConfig.isValidTail(tail)) {
            return tail;
        }
        return "";
    }

    public static String tailless(String build) {
        if (RePlacerConfig.isInclTail() || !RePlacerConfig.hasTail(build)) {
            return build;
        }
        return RePlacerConfig.removeTail(build);
    }

    static String removeTail(String build) {
        if (!RePlacerConfig.hasTail(build)) {
            return build;
        }
        return build.substring(0, build.indexOf(DIV));
    }

    static int parseAccess(String name) {
        if (!RePlacerConfig.hasTail(name) || !RePlacerConfig.isValidTail(RePlacerConfig.tail(name))) {
            return -1;
        }
        String remainder = RePlacerConfig.tail(name).replaceAll(REGEX, "");
        if (remainder.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(remainder);
    }

    public static boolean hasQuickAccess(int slot) {
        return quickAccess.containsKey(slot);
    }

    public static String getQuickAccessName() {
        return quickAccess.get(RePlacerClient.getQuickAccess());
    }

    static void startReCording(boolean val) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        reCording = val;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static BuildHolder buildDefault() {
        return new BuildHolder(class_2350.field_11036, class_2350.field_11043, new RelPos(0, 0, 0), new RelPos(0, 0, 1), new RelPos(0, 0, -1), new RelPos(1, 0, 0), new RelPos(1, 0, 1), new RelPos(1, 0, -1), new RelPos(-1, 0, 0), new RelPos(-1, 0, 1), new RelPos(-1, 0, -1));
    }

    static CellErrorSupplier getCellErrorSupplier() {
        return new CellErrorSupplier();
    }

    static DefaultErrorSupplier getDefaultErrorSupplier() {
        return new DefaultErrorSupplier();
    }

    static NameErrorSupplier getNameErrorSupplier() {
        return new NameErrorSupplier();
    }

    static BoolErrorSupplier getBoolErrorSupplier() {
        return new BoolErrorSupplier();
    }

    static ErrorSupplier getErrorSupplier() {
        return new ErrorSupplier();
    }

    static {
        selection = 0;
        reCording = false;
        isHollow = false;
        deny = false;
        quickAccess = new HashMap<Integer, String>();
        listSideCombinedErrorChecker = null;
        boolSideCombinedErrorChecker = null;
    }

    private static class CellErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private CellErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if ((entry = entry.toLowerCase()).indexOf(RePlacerConfig.DIV) != entry.lastIndexOf(RePlacerConfig.DIV)) {
                return Optional.of(class_2561.method_43470((String)"You cannot have more than one modifier tail! error code: 0"));
            }
            if (!RePlacerConfig.hasTail(entry) || RePlacerConfig.isValidTail(RePlacerConfig.tail(entry))) {
                return Optional.empty();
            }
            if (RePlacerConfig.tail(entry).isEmpty()) {
                return Optional.of(class_2561.method_43470((String)"Tail is empty! error code: 1"));
            }
            return Optional.of(class_2561.method_43470((String)("Illegal characters:" + entry.replaceFirst(RePlacerConfig.SPIN, "").replaceFirst(RePlacerConfig.SNAP, "").replaceFirst(RePlacerConfig.NO, "").replaceFirst(RePlacerConfig.REGEXNUM, "") + " error code: 2")));
        }
    }

    private static class DefaultErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private DefaultErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if (entry.isEmpty()) {
                return Optional.empty();
            }
            if (RePlacerConfig.hasTail(entry)) {
                return Optional.of(class_2561.method_43470((String)"Enter tailless version! error code: 8"));
            }
            if (!RePlacerConfig.getTaillessNames().contains(entry)) {
                return Optional.of(class_2561.method_43470((String)"Build does not exist! error code: 9"));
            }
            return Optional.empty();
        }
    }

    private static class NameErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private NameErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if (!RePlacerConfig.hasTail(entry) || RePlacerConfig.isValidTail(RePlacerConfig.tail(entry))) {
                if (RePlacerConfig.getTaillessNames().contains(RePlacerConfig.removeTail(entry))) {
                    return Optional.of(class_2561.method_43470((String)"Duplicate name! error code: 6"));
                }
                return Optional.empty();
            }
            return Optional.of(class_2561.method_43470((String)("Illegal characters in tail:" + RePlacerConfig.tail(entry).replaceFirst(RePlacerConfig.SPIN, "").replaceFirst(RePlacerConfig.SNAP, "").replaceFirst(RePlacerConfig.NO, "").replaceFirst(RePlacerConfig.REGEXNUM, "") + " error code: 7")));
        }
    }

    private static class BoolErrorSupplier
    implements Function<Boolean, Optional<class_2561>> {
        private BoolErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(Boolean entry) {
            boolSideCombinedErrorChecker = false;
            if (entry.booleanValue() && listSideCombinedErrorChecker.booleanValue()) {
                return Optional.of(class_2561.method_43470((String)"Can't turn this on if all your builds are quickaccess! error code: 10"));
            }
            return Optional.empty();
        }
    }

    private static class ErrorSupplier
    implements Function<List<String>, Optional<class_2561>> {
        private ErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(List<String> entry) {
            listSideCombinedErrorChecker = false;
            if (entry.isEmpty()) {
                return Optional.empty();
            }
            HashSet<Integer> quickInts = new HashSet<Integer>();
            HashSet<String> taillessNames = new HashSet<String>(RePlacerConfig.getTaillessNames());
            HashSet<String> names = new HashSet<String>();
            for (String build : entry) {
                String tail;
                String tailless = RePlacerConfig.removeTail(build);
                if (names.contains(tailless)) {
                    return Optional.of(class_2561.method_43470((String)("Duplicate build name: " + tailless + "! error code: 3")));
                }
                if (!taillessNames.contains(tailless)) {
                    if (JsonConfigHelper.hasCachedBuild(build)) {
                        return Optional.empty();
                    }
                    return Optional.of(class_2561.method_43470((String)"You cannot add builds or change their names here! error code: 4"));
                }
                names.add(tailless);
                if (!RePlacerConfig.hasTail(build) || (tail = RePlacerConfig.tail(build)).replaceAll(RePlacerConfig.REGEX, "").isEmpty()) continue;
                int i = Integer.parseInt(tail.replaceAll(RePlacerConfig.REGEX, ""));
                if (!quickInts.add(i)) {
                    return Optional.of(class_2561.method_43470((String)(i + "can only be bound to one build! error code: 5")));
                }
                if (quickInts.size() != entry.size()) continue;
                if (boolSideCombinedErrorChecker.booleanValue()) {
                    return Optional.of(class_2561.method_43470((String)"Cannot remove all builds from cycling! error code: 11"));
                }
                listSideCombinedErrorChecker = true;
            }
            return Optional.empty();
        }
    }
}

