package eva.replacer.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import net.minecraft.class_2561;
import java.util.List;

import static eva.replacer.config.RePlacerConfig.*;

public class RePlacerConfigScreen implements ModMenuApi {
    public static ConfigBuilder builder() {
        ConfigBuilder builder = ConfigBuilder.create()
                .setTitle(class_2561.method_43470("RePlacer Config"))
                .setEditable(true);
        if (reCording) {
            builder.setSavingRunnable(RePlacerConfig::saveBuild);
            builder.getOrCreateCategory(class_2561.method_43470("Confirm build save?"))
                    .addEntry(builder.entryBuilder()
                            .startStrField(class_2561.method_43470("Build Name:"), "")
                            .setTooltip(class_2561.method_43470("This will be the build's name.\nThe build is what you just made!"))
                            .setSaveConsumer(newName -> buildName = newName)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Should the first block be included?"), true)
                            .setTooltip(class_2561.method_43470("If this says no, building this will\nnot require that any given block\nactually placeable."))
                            .setSaveConsumer(newVal -> isHollow = !newVal)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Click this to allow current build to be discarded"), false)
                            .setTooltip(class_2561.method_43470("If this is positive, your build will be deleted!"))
                            .setSaveConsumer(newVal -> deny = newVal)
                            .build()
                    );
        } else {
            builder.setSavingRunnable(JsonConfigHelper::writeToConfig);
            builder.getOrCreateCategory(class_2561.method_43470("Options"))
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Placement-based rotation:"), isRotatePlace())
                            .setTooltip(class_2561.method_43470("Builds 'sprout' out of the block you place them on"))
                            .setSaveConsumer(RePlacerConfig::setRotatePlace)
                            .setDefaultValue(true)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Player direction-based rotation:"), isRotateFace())
                            .setTooltip(class_2561.method_43470("Builds go spin"))
                            .setSaveConsumer(RePlacerConfig::setRotateFace)
                            .setDefaultValue(true)
                            .build()
                    );
            builder.getOrCreateCategory(class_2561.method_43470("Build Management"))
                    .addEntry(builder.entryBuilder()
                            .startStrList(class_2561.method_43470("Build Names:"), getNames())
                            .setDeleteButtonEnabled(true)
                            .setRemoveButtonTooltip(class_2561.method_43470("Deleting this will delete the build!"))
                            .setExpanded(true)
                            .setSaveConsumer(RePlacerConfig::buildDeleter)
                            .setDefaultValue(List.of("square"))
                            .build()
                    );
            builder.getOrCreateCategory(class_2561.method_43470("ReCorder"))
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("ReCord on Menu Close:"), reCording)
                            .setSaveConsumer(value -> reCording = value)
                            .setTooltip(class_2561.method_43470("If this is on, your block\nplacements will be recorded\nas a build until you turn\nit off"))
                            .build()
                    );
        }
        return builder;
    }

    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        JsonConfigHelper.createBuilds();
        return parent -> {
            // Return the screen here with the one you created from Cloth Config Builder
            return builder().setParentScreen(parent).build();
        };
    }

}