package eva.replacer.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.class_2350;
import net.minecraft.class_243;

import static eva.replacer.config.RePlacerConfig.isRotateFace;
import static eva.replacer.config.RePlacerConfig.isRotatePlace;

public record BuildHolder(class_2350 firstDir, @Nullable class_2350 faceDir, int[] x, int[] y, int[] z) {
    private static class_2350 baseDir;
    private static class_2350 facing;

    private BuildHolder(class_2350 firstDir, class_2350 faceDir, int @NotNull [][] tri) {
        this(firstDir, faceDir, tri[0], tri[1], tri[2]);
    }
    public BuildHolder(class_2350 firstDir, class_2350 faceDir, RelPos... posList) {
        this(firstDir, faceDir, split(sort(posList)));
    }

    public static void setBaseDir(class_2350 baseDir) {
        BuildHolder.baseDir = baseDir;
    }
    public static void setFacing(@NotNull class_243 v0, @NotNull class_2350 placeFace) {
        double[] v1 = {v0.field_1352, v0.field_1351, v0.field_1350};
        v1[placeFace.method_10166().ordinal()] = 0.0;
        BuildHolder.facing = class_2350.method_58251(new class_243(v1[0], v1[1], v1[2]).method_1029());
    }

    RelPos rotatePlace(RelPos pos) {
        if (!isRotatePlace() || this.firstDir == baseDir)
            return pos;
        if (this.firstDir().method_10166() == baseDir.method_10166()) {
            int[] vals = {pos.vals()[0], pos.vals()[1], pos.vals()[2]};
            vals[this.firstDir().method_10166().ordinal()] *= -1;
            return new RelPos(vals);
        }
        int[] ind = {this.firstDir().method_10166().ordinal(), baseDir.method_10166().ordinal()};
        int[] neg;
        if (this.firstDir().method_10171() != baseDir.method_10171())
            neg = new int[]{-1, 1};
        else
            neg = new int[]{1, -1};
        int[] vals = new int[3];
        vals[ind[0]] = pos.vals()[ind[1]] * neg[1];
        vals[ind[1]] = pos.vals()[ind[0]] * neg[0];
        vals[3 - ind[0] - ind[1]] = pos.vals()[3 - ind[0] - ind[1]];
        return new RelPos(vals);
    }

    RelPos rotateFace(RelPos pos) {
        class_2350 tempDir = rot();
        if (!isRotateFace() || this.faceDir == null || facing == tempDir)
            return pos;
        assert tempDir != null;
        if (facing.method_10166() == tempDir.method_10166()) {
            int[] vals = new int[3];
            if (facing.method_10166() == class_2350.class_2351.field_11052) {
                vals[0] = pos.vals()[0];
                vals[1] = -pos.vals()[1];
                vals[2] = pos.vals()[2];
            } else if (facing.method_10166() == class_2350.class_2351.field_11048) {
                vals[0] = -pos.vals()[0];
                vals[1] = pos.vals()[1];
                vals[2] = pos.vals()[2];
            } else {
                vals[0] = pos.vals()[0];
                vals[1] = pos.vals()[1];
                vals[2] = -pos.vals()[2];
            }
            return new RelPos(vals);
        } else {
            class_2350.class_2351 ax = class_2350.class_2351.values()[3 - tempDir.method_10166().ordinal() - facing.method_10166().ordinal()];
            if ((tempDir.method_35833(ax) == facing)/* && ax == Direction.Axis.Y) || (tempDir.getCounterClockWise(ax) == facing && ax != Direction.Axis.Y)*/) {
                if (ax == class_2350.class_2351.field_11052)
                    return new RelPos(-pos.vals()[2], pos.vals()[1], pos.vals()[0]);
                else if (ax == class_2350.class_2351.field_11048) {
                    return new RelPos(pos.vals()[0], -pos.vals()[2], -pos.vals()[1]);
                } else
                    return new RelPos(pos.vals()[1], pos.vals()[0], pos.vals()[2]);
            } else {
                if (ax == class_2350.class_2351.field_11052)
                    return new RelPos(pos.vals()[2], pos.vals()[1], -pos.vals()[0]);
                else if (ax == class_2350.class_2351.field_11048)
                    return new RelPos(pos.vals()[0], pos.vals()[2], pos.vals()[1]);
                else
                    return new RelPos(-pos.vals()[1], -pos.vals()[0], pos.vals()[2]);
            }
        }
    }

    public void rotateEach(Consumer<RelPos> action) {
        for (int i = 0; i < this.x.length; i++) {
            RelPos pos = new RelPos(this.x[i], this.y[i], this.z[i]);
            if (pos.equals(RelPos.origin)) continue;
            if (!(isRotatePlace() || isRotateFace()))
                action.accept(pos);
            else
                action.accept(rotateFace(rotatePlace(pos)));
        }
    }

    private @Nullable class_2350 rot() {
        if (this.faceDir == null) return null;
        try {
            if (this.firstDir.method_10166().equals(baseDir.method_10166())) return this.faceDir;
            class_2350.class_2351 ax = class_2350.class_2351.values()[3 - this.firstDir.method_10166().ordinal() - baseDir.method_10166().ordinal()];
            if (this.firstDir.method_10166() == class_2350.class_2351.field_11052 && this.faceDir.method_10166() != baseDir.method_10166()) {
                if (facing.method_10166() == class_2350.class_2351.field_11052) return this.faceDir.method_10153();
                if (this.firstDir.method_35833(ax) == baseDir) return this.faceDir.method_35834(ax);
                return this.faceDir.method_35833(ax);
            }
            if (this.firstDir.method_35834(ax) == baseDir)
                return this.faceDir.method_35834(ax);
            return this.faceDir.method_35833(ax);
        } catch (NullPointerException e) {
            return this.faceDir;
        }
    }

    private static RelPos[] sort(RelPos[] posList) {
        Arrays.sort(posList, Comparator.comparingDouble(RelPos::dist));
        return posList;
    }

    private static int @NotNull [][] split(RelPos @NotNull [] posList) {
        int[][] ret = new int[3][posList.length];
        for (int i = 0; i < 3; i++)
            for (int j = 0; j < posList.length; j++)
                ret[i][j] = posList[j].vals()[i];
        return ret;
    }

    public RelPos @NotNull [] posList() {
        if (this.x.length != this.y.length || this.z.length != this.x.length) throw new IllegalArgumentException();
        RelPos[] posList = new RelPos[this.x.length];
        for (int i = 0; i < this.x.length; i++) {
            posList[i] = new RelPos(this.x[i], this.y[i], this.z[i]);
        }
        return posList;
    }

    @SuppressWarnings("SameReturnValue")
    public boolean sort() {
        if (this.x.length != this.y.length || this.z.length != this.x.length) throw new IllegalArgumentException();
        RelPos[] posList = sort(this.posList());
        for (int i = 0; i < posList.length; i++) {
            this.x[i] = posList[i].vals()[0];
            this.y[i] = posList[i].vals()[1];
            this.z[i] = posList[i].vals()[2];
        }
        return true;
    }
}
