package eva.replacer.mixin.client;

import eva.replacer.RePlacerClient;
import eva.replacer.util.BuildInProgress;
import eva.replacer.util.RelPos;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_2561;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static eva.replacer.RePlacerClient.isHeldOrToggled;
import static eva.replacer.config.JsonConfigHelper.writeSquare;
import static eva.replacer.config.RePlacerConfig.*;
import static eva.replacer.util.BuildHolder.setBaseDir;
import static eva.replacer.util.BuildHolder.setFacing;
import static eva.replacer.util.BuildInProgress.rePlacing;
import static eva.replacer.util.BuildInProgress.setReadyForBlock;

@Mixin(class_1747.class)
public class BlockItemMixin {

    @Unique private final class_1747 blit = (class_1747) (Object) this;
    @Unique private boolean no = false;
    @Inject(
            method = "place",
            at = @At("TAIL")
    )
    private void placeAgain(class_1750 context, CallbackInfoReturnable<class_1269> cir) {
        if (no) {
            no = false;
            return;
        }
        if (rePlacing())
            return;
        if (reCording) {
            if (buildSaver(context)) {
                assert context.method_8036() != null;
                context.method_8036().method_7353(class_2561.method_43470("Central block saved!"), true);
            }
            return;
        }
        if (!isHeldOrToggled()) return;
        class_1657 player = context.method_8036();
        assert player != null;
        if (getBuild() == null) {
            RePlacerClient.LOGGER.info("Failed to get build!");
            player.method_7353(class_2561.method_43470("Failed to get build!"), true);
            player.method_7353(class_2561.method_43470("Writing default build."), false);
            writeSquare();
            no = true;
            return;
        }
        rePlacing(true);
        RelPos.setBase(context.method_17698(), context.method_8037());
        try {
            if (isRotatePlace()) setBaseDir(context.method_8038());
            if (isRotateFace()) setFacing(player.method_5720(), context.method_8038());
            if (isCompatMode()) {
                BuildInProgress.pass(context);
                setReadyForBlock(false);
                getBuild().rotateEach(true, BuildInProgress::pass);
                return;
            } else getBuild().rotateEach(true, pos -> {
                if (player.method_56093(pos.pos(), player.method_55754() + 1)) {
                    BuildInProgress.place(pos, context, context.method_8036(), blit);
                }
            });
        } catch (Exception ignored) {}
        rePlacing(false);
    }
}
