package eva.replacer;

import com.terraformersmc.modmenu.ModMenu;
import eva.replacer.config.JsonConfigHelper;
import eva.replacer.config.RePlacerConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static eva.replacer.config.JsonConfigHelper.checkUpdates;
import static eva.replacer.config.JsonConfigHelper.writeSquare;
import static eva.replacer.config.RePlacerConfig.*;
import static eva.replacer.util.BuildInProgress.clear;
import static eva.replacer.util.BuildInProgress.rePlacing;

public class RePlacerClient implements ClientModInitializer {
    public static final String MOD_ID = RePlacerMain.MOD_ID + "-client";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    private static boolean toggled = false;
    private static boolean modMenu = false;
    public static final class_304 modifierBind;
    public static final class_304 cycleBind;
    public static final class_304 modifierToggle;
    private static int quickAccess = 0;
    private static boolean isQuickAccess = false;
    private static final boolean[] fixHold = new boolean[2];
    private static final class_304.class_11900 REPLACER_KEYS = new class_304.class_11900(class_2960.method_43902("eva", "replacer"));
    static {
        modifierBind = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Modifier Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_LEFT_ALT,
                REPLACER_KEYS
        ));
        cycleBind = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Cycle Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_Z,
                REPLACER_KEYS
        ));
        modifierToggle = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Modifier Toggle Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_UNKNOWN,
                REPLACER_KEYS
        ));
    }

    @Override
    public void onInitializeClient() {
        modMenu = FabricLoader.getInstance().isModLoaded("modmenu");

        JsonConfigHelper.init();
        bindInit();
        serverCheckInit();

    }

    private static void bindInit() {
        // This entrypoint is suitable for setting up client-specific logic, such as rendering.

        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            checkUpdates();
            assert client.field_1724 != null;
            fixHold[1] = false;
            if (cycleBind.method_1434() != fixHold[0]) {
                fixHold[0] = !fixHold[0];
                if (cycleBind.method_1434()) fixHold[1] = true;
            }
            if (modMenu && modifierBind.method_1434() && fixHold[1]) {
                if (isReCording()) {
                    try {
                        client.method_1507(ModMenu.getConfigScreen("rp", client.field_1755));
                    } catch (Exception e) {LOGGER.info("Update cloth or mod menu!");}
                } else {
                    client.field_1724.method_7353(class_2561.method_43470("Recording started!"), true);
                    setReCording(true);
                }
            } else if (fixHold[1]) {
                if (rePlacing()) {
                    rePlacing(false);
                    clear();
                } else if (isQuickAccess()) {
                    isQuickAccess = false;
                    client.field_1724.method_7353(class_2561.method_43470("Quick build canceled"), true);
                } else if (!isReCording()) {
                    cycleSelection(client.field_1724.method_5715(), 0);
                    try {
                        client.field_1724.method_7353(class_2561.method_43470("swapped to " + tailless(getNames().get(getSelection()))), true);
                    } catch (Exception ignored) {
                        client.field_1724.method_7353(class_2561.method_43470("No builds registered!"), false);
                        client.field_1724.method_7353(class_2561.method_43470("Loading default build"), false);
                        writeSquare();
                        tareSelection();
                        client.field_1724.method_7353(class_2561.method_43470("swapped to square"), true);
                    }
                }
            }
            if (!isQuickAccess && modifierToggle.method_1436()) {
                toggled = !toggled;
            }
        });
    }

    public static boolean isQuickAccess() {
        return isQuickAccess;
    }

    public static void setQuickAccess(int i) {
        quickAccess = i;
        isQuickAccess = i > -1;
        toggled = false;
    }

    public static int getQuickAccess() {
        return quickAccess;
    }

    public static boolean isHeldOrToggled() {
        return toggled || modifierBind.method_1434() || isQuickAccess;
    }
    public static boolean isHoldingEither() {
        return modifierToggle.method_1434() || modifierBind.method_1434();
    }

    private static void serverCheckInit() {
        ClientConfigurationConnectionEvents.COMPLETE.register((handler, server) -> RePlacerConfig.isServer = !server.method_1542());
        ClientConfigurationConnectionEvents.DISCONNECT.register((handler, server) -> {
            RePlacerConfig.isServer = null;
            deny = true;
            saveBuild();
        });
    }

}