/*
 * Decompiled with CFR 0.152.
 */
package com.naturaltemperature;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="naturaltemperature", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.DoubleValue EQUATORIAL_DISTANCE = BUILDER.comment("Equatorial distance is the distance between the spawn point and the equator, measured in blocks.The spawn point is located in the northern hemisphere, equidistant between the north pole and the equator.Since the Minecraft world is immense, the poles are defined as the zones with the lowest possible temperature to the north and south.Beyond those zones, the temperature remains consistently low until the world border.You will find the north pole 1 equatorial distance (eqd) north, the equator 1 eqd south, and the south pole 3 eqd south.Temperate zone is between 0 and 1/3 eqd north and 2 eqd south and 7/3 eqd southDeserts will spawn around 1/3 eqd south, and jungles at 2/3 eqd.In the north, cold biomes begin around 1/3 eqd north, and very cold biomes at 2/3 eqd.Some references: Earth-like: eqd= 10000000, Mars-like: eqd= 5000000, Moon-like: eqd= 2500000, Ceres-like: eqd=750000, Default: eqd= 50000, very small: eqd= 10000, The line: eqd= 100, Frostpunk: eqd=0").defineInRange("equatorial_distance", 50000.0, 0.0, 6.0E12);
    public static final ForgeConfigSpec.BooleanValue LOOPING_WORLD = BUILDER.comment("Set to true if you want the biomes' distribution pattern to loop until world border after the very cold regions").define("looping_world", false);
    public static final ForgeConfigSpec.IntValue GENERATION_MODE = BUILDER.comment("0: DEFAULT, 1: SIMPLIFIED, 2: LINEAR. You can see examples on the official modrinth page: https://modrinth.com/mod/natural-temperature/gallery").defineInRange("generation_mode", 0, 0, 2);
    public static final ForgeConfigSpec.DoubleValue EQUATOR_OFFSET = BUILDER.comment("Positive values will move the equator to the north, if you want the equator to be at 0 set this value the same as your equatorial_distance").defineInRange("equator_offset", 0.0, -6.0E12, 6.0E12);
    public static final ForgeConfigSpec.BooleanValue RANDOMIZE_UNDERGROUND = BUILDER.comment("Set it to true to ignore the biome distribution pattern of the surface, useful for mods that generate underground biomes like terralith").define("randomize_underground", false);
    public static final ForgeConfigSpec.DoubleValue RANDOMIZE_UNDERGROUND_BELOW_Y = BUILDER.comment("Randomize the underground below this y").defineInRange("randomize_underground_below_y", 45.0, -6.0E12, 6.0E12);
    public static final ForgeConfigSpec.IntValue UNDERGROUND_RANDOMIZATION_TYPE = BUILDER.comment("0: random (total randomness), 1: half_random (some degree of similarity with biomes on the surface)").defineInRange("underground_randomization_type", 1, 0, 1);
    public static final ForgeConfigSpec.BooleanValue MULTIDIMENSIONAL_BANDS = BUILDER.comment("True will use banded world generation also in the other dimensions").define("multidimensional_bands", false);
    public static final ForgeConfigSpec.DoubleValue GLOBAL_TEMPERATURE_MODIFIER_PERCENTAGE = BUILDER.comment("A percentage for heating or cooling the planet. Range (-100.0 , 100.0)").defineInRange("global_temperature_modifier_percentage", 0.0, -100.0, 100.0);
    public static final ForgeConfigSpec.DoubleValue GLOBAL_TEMPERATURE_MITIGATION_PERCENTAGE = BUILDER.comment("A percentage to mitigate the planet climate (this reduce extreme climatic regions). Range (0.0 , 100.0)").defineInRange("global_temperature_mitigation_percentage", 0.0, 0.0, 100.0);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static double equatorial_distance;
    public static boolean looping_world;
    public static int generation_mode;
    public static double equator_offset;
    public static boolean randomize_underground;
    public static double randomize_underground_below_y;
    public static int underground_randomization_type;
    public static boolean multidimensional_bands;
    public static double global_temperature_modifier_percentage;
    public static double global_temperature_mitigation_percentage;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        equatorial_distance = (Double)EQUATORIAL_DISTANCE.get();
        looping_world = (Boolean)LOOPING_WORLD.get();
        generation_mode = (Integer)GENERATION_MODE.get();
        equator_offset = (Double)EQUATOR_OFFSET.get();
        randomize_underground = (Boolean)RANDOMIZE_UNDERGROUND.get();
        randomize_underground_below_y = (Double)RANDOMIZE_UNDERGROUND_BELOW_Y.get();
        underground_randomization_type = (Integer)UNDERGROUND_RANDOMIZATION_TYPE.get();
        multidimensional_bands = (Boolean)MULTIDIMENSIONAL_BANDS.get();
        global_temperature_modifier_percentage = (Double)GLOBAL_TEMPERATURE_MODIFIER_PERCENTAGE.get();
        global_temperature_mitigation_percentage = (Double)GLOBAL_TEMPERATURE_MITIGATION_PERCENTAGE.get();
    }
}

