/*
 * Decompiled with CFR 0.152.
 */
package com.naturaltemperature;

import com.naturaltemperature.NaturalTemperature;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class NaturalTemperaturePluginMixin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        NaturalTemperature.LOGGER.info("[NaturalTemperature] Mixin plugin loaded: " + mixinPackage);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Map<String, String> conditionalMixins = Map.of("TerrablenderCompatMixin", "terrablender", "BlueprintCompatMixin", "ntplaceholder");
        for (Map.Entry<String, String> entry : conditionalMixins.entrySet()) {
            String mixinSuffix = entry.getKey();
            String modid = entry.getValue();
            if (!mixinClassName.endsWith(mixinSuffix)) continue;
            boolean loaded = this.isModLoadedEarly(modid);
            NaturalTemperature.LOGGER.info("[NaturalTemperature] Checking mixin: " + mixinClassName + " \u2014 Is " + modid + " loaded \u2192 " + (loaded ? "Yes, ENABLE" : "No, SKIP") + " mixin");
            return loaded;
        }
        boolean terrablenderLoaded = this.isModLoadedEarly("ntplaceholder");
        if (mixinClassName.endsWith("NoiseSelectorMixin")) {
            boolean enabled = terrablenderLoaded;
            NaturalTemperature.LOGGER.info("[NaturalTemperature] Checking mixin: " + mixinClassName + " \u2014 Is ntplaceholder loaded \u2192 " + (enabled ? "Yes, SKIP" : "No, ENABLE") + " mixin");
            return !enabled;
        }
        NaturalTemperature.LOGGER.info("[NaturalTemperature] Applying mixin: " + mixinClassName);
        return true;
    }

    private boolean isModLoadedEarly(String modid) {
        try {
            return FMLLoader.getLoadingModList().getModFileById(modid) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

