/*
 * Decompiled with CFR 0.152.
 */
package com.naturaltemperature.mixin;

import com.naturaltemperature.Config;
import com.naturaltemperature.GenMode;
import com.naturaltemperature.NoiseBiomeBandsGenerator;
import com.naturaltemperature.WorldSeedHolder;
import com.naturaltemperature.mixin.SamplerAccessor;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Climate.Sampler.class})
public class TemperatureMixin {
    private final NoiseBiomeBandsGenerator noiseGenerator = new NoiseBiomeBandsGenerator(WorldSeedHolder.getSeed());

    @Inject(method={"sample"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyTemperature(int x, int y, int z, CallbackInfoReturnable<Climate.TargetPoint> cir) {
        int i = QuartPos.m_175402_((int)x);
        int j = QuartPos.m_175402_((int)y);
        int k = QuartPos.m_175402_((int)z);
        DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(i, j, k);
        SamplerAccessor accessor = (SamplerAccessor)((Object)this);
        DensityFunction continentalness = accessor.getContinentalness();
        DensityFunction erosion = accessor.getErosion();
        DensityFunction depth = accessor.getDepth();
        DensityFunction weirdness = accessor.getWeirdness();
        float customTemperature = this.customTemperatureCalculation(i, j, k);
        float customHumidity = this.customHumidityCalculation(i, j, k);
        float continentalnessValue = (float)continentalness.m_207386_((DensityFunction.FunctionContext)context);
        float erosionValue = (float)erosion.m_207386_((DensityFunction.FunctionContext)context);
        float depthValue = (float)depth.m_207386_((DensityFunction.FunctionContext)context);
        float weirdnessValue = (float)weirdness.m_207386_((DensityFunction.FunctionContext)context);
        Climate.TargetPoint customPoint = Climate.m_186781_((float)customTemperature, (float)customHumidity, (float)continentalnessValue, (float)erosionValue, (float)depthValue, (float)weirdnessValue);
        cir.setReturnValue((Object)customPoint);
    }

    private float customTemperatureCalculation(int x, int y, int z) {
        double t;
        DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(x, y, z);
        DensityFunction temperature = ((SamplerAccessor)((Object)this)).getHumidity();
        double a = Config.equatorial_distance;
        boolean s = Config.looping_world;
        int m = Config.generation_mode;
        double offset = Config.equator_offset;
        double scale = 6.0;
        double distortionAmplitude = 30.0;
        double waveFrequency = 0.01;
        double waveAmplitude = 30.0;
        double noise = this.noiseGenerator.getNoise(x, z, scale);
        double wave = Math.sin((double)x * waveFrequency) * waveAmplitude;
        double adjustedZ = (double)z + noise * distortionAmplitude + wave + offset;
        double mod = 4.0 * a;
        double mad_z = (((double)z + offset + noise * distortionAmplitude + wave) % mod + mod) % mod;
        double zp = (double)z + offset;
        boolean randomize_underground = Config.randomize_underground;
        double underground_line = Config.randomize_underground_below_y;
        int underground_randomization_type = Config.underground_randomization_type;
        double globalTemperatureModifier = Config.global_temperature_modifier_percentage / 100.0;
        double globalMitigation = 1.0 - Math.abs(Config.global_temperature_mitigation_percentage / 100.0);
        double random_t = (float)temperature.m_207386_((DensityFunction.FunctionContext)context);
        double f1 = 0.0;
        double f2 = 0.0;
        if (underground_randomization_type == 0) {
            f1 = 1.0;
            f2 = 0.0;
        } else if (underground_randomization_type == 1) {
            f1 = 0.75;
            f2 = 0.25;
        }
        double SavannaStart = 0.0;
        double JungleStart = 0.6666666666666666 * a;
        double DesertStart2 = 1.3333333333333333 * a;
        switch (switch (m) {
            case 2 -> GenMode.LINEAR;
            case 1 -> GenMode.SIMPLIFIED;
            default -> GenMode.DEFAULT;
        }) {
            case DEFAULT: {
                if (a == 0.0) {
                    t = -1.0;
                } else if (mad_z >= SavannaStart && mad_z <= JungleStart || mad_z >= DesertStart2 && mad_z <= 4.0 * a) {
                    t = 0.7639437268410976 * Math.asin(Math.sin(Math.PI * adjustedZ / (2.0 * a))) + 0.2;
                    t = Math.max(Math.min(1.0, t * globalMitigation + globalTemperatureModifier), -1.0);
                } else {
                    t = mad_z > JungleStart && mad_z < DesertStart2 ? 2.0 * Math.tanh(2.5 * Math.cos(Math.PI * adjustedZ / a)) + 2.3 : -1.0;
                }
                if (!s && (zp <= -1.0 * a || zp >= 3.0 * a)) {
                    t = -1.0;
                }
                if (!((double)y <= underground_line) || !randomize_underground) break;
                t = random_t * f1 + t * f2;
                break;
            }
            case SIMPLIFIED: {
                if (!s) {
                    if (a == 0.0) {
                        t = -1.0;
                    } else if (zp >= -a && zp <= 3.0 * a) {
                        t = 0.6366197723675814 * Math.asin(Math.sin(Math.PI * adjustedZ / (2.0 * a)));
                        t = Math.max(Math.min(1.0, t * globalMitigation + globalTemperatureModifier), -1.0);
                    } else {
                        t = -1.0;
                    }
                } else if (a == 0.0) {
                    t = -1.0;
                } else {
                    t = 0.6366197723675814 * Math.asin(Math.sin(Math.PI * adjustedZ / (2.0 * a)));
                    t = Math.max(Math.min(1.0, t * globalMitigation + globalTemperatureModifier), -1.0);
                }
                if (!((double)y <= underground_line) || !randomize_underground) break;
                t = random_t * f1 + t * f2;
                break;
            }
            case LINEAR: {
                t = Math.max(Math.min(1.0, 1.0 / a * adjustedZ), -1.0);
                t = Math.max(Math.min(1.0, t * globalMitigation + globalTemperatureModifier), -1.0);
                if (!((double)y <= underground_line) || !randomize_underground) break;
                t = random_t * f1 + t * f2;
                break;
            }
            default: {
                if (a == 0.0) {
                    t = -1.0;
                } else if (mad_z >= SavannaStart && mad_z <= JungleStart || mad_z >= DesertStart2 && mad_z <= 4.0 * a) {
                    t = 0.7639437268410976 * Math.asin(Math.sin(Math.PI * adjustedZ / (2.0 * a))) + 0.2;
                    t = Math.max(Math.min(1.0, t * globalMitigation + globalTemperatureModifier), -1.0);
                } else {
                    t = mad_z > JungleStart && mad_z < DesertStart2 ? 2.0 * Math.tanh(2.5 * Math.cos(Math.PI * adjustedZ / a)) + 2.3 : -1.0;
                }
                if (!s && (zp <= -1.0 * a || zp >= 3.0 * a)) {
                    t = -1.0;
                }
                if (!((double)y <= underground_line) || !randomize_underground) break;
                t = random_t * f1 + t * f2;
            }
        }
        return (float)t;
    }

    private float customHumidityCalculation(int x, int y, int z) {
        double u;
        DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(x, y, z);
        DensityFunction humidity = ((SamplerAccessor)((Object)this)).getHumidity();
        double a = Config.equatorial_distance;
        boolean s = Config.looping_world;
        int m = Config.generation_mode;
        double offset = Config.equator_offset;
        double scale = 6.0;
        double distortionAmplitude = 30.0;
        double waveFrequency = 0.01;
        double waveAmplitude = 30.0;
        double noise = this.noiseGenerator.getNoise(x, z, scale);
        double wave = Math.sin((double)x * waveFrequency) * waveAmplitude;
        double mod = 4.0 * a;
        double mad_z = (((double)z + offset + noise * distortionAmplitude + wave) % mod + mod) % mod;
        double adjustedZ = (double)z + noise * distortionAmplitude + wave + offset;
        double zp = (double)z + offset;
        double NPoleWaveZ = noise * distortionAmplitude + wave - 1.0 * a;
        double SPoleWaveZ = noise * distortionAmplitude + wave + 3.0 * a;
        double JungleStart = 0.6666666666666666 * a;
        double DesertStart2 = 1.3333333333333333 * a;
        double SavannaStart = 0.0;
        double DesertStart = 0.3333333333333333 * a;
        double SavannaStart2 = 1.6666666666666667 * a;
        double PoleStart2 = 2.6666666666666665 * a;
        double ColdStart3 = 3.3333333333333335 * a;
        double TempStart2 = 2.0 * a;
        boolean randomize_underground = Config.randomize_underground;
        double underground_line = Config.randomize_underground_below_y;
        int underground_randomization_type = Config.underground_randomization_type;
        double random_u = (float)humidity.m_207386_((DensityFunction.FunctionContext)context);
        double f1 = 1.0;
        double f2 = 0.0;
        if (underground_randomization_type == 0) {
            f1 = 1.0;
            f2 = 0.0;
        } else if (underground_randomization_type == 1) {
            f1 = 0.75;
            f2 = 0.25;
        }
        float t = this.customTemperatureCalculation(x, y, z);
        switch (switch (m) {
            case 2 -> GenMode.LINEAR;
            case 1 -> GenMode.SIMPLIFIED;
            default -> GenMode.DEFAULT;
        }) {
            case DEFAULT: {
                boolean underJungle = false;
                if (a == 0.0) {
                    u = -1.0;
                } else if (mad_z >= SavannaStart && mad_z <= DesertStart || mad_z >= SavannaStart2 && mad_z <= TempStart2) {
                    u = -1.0;
                } else if (mad_z >= JungleStart && mad_z <= DesertStart2) {
                    u = Math.signum(Math.cos(Math.PI * 2 * adjustedZ / a));
                    underJungle = true;
                } else {
                    u = mad_z >= PoleStart2 && mad_z <= ColdStart3 ? -1.0 : (mad_z >= DesertStart && mad_z <= JungleStart || mad_z >= DesertStart2 && mad_z <= SavannaStart2 ? ((double)t <= 0.65 ? -1.0 : (double)((float)humidity.m_207386_((DensityFunction.FunctionContext)context))) : (double)((float)humidity.m_207386_((DensityFunction.FunctionContext)context)));
                }
                if (!s && (zp >= SPoleWaveZ || zp <= NPoleWaveZ)) {
                    u = -1.0;
                }
                if (!((double)y <= underground_line) || !randomize_underground || underJungle) break;
                u = random_u * f1 + u * f2;
                break;
            }
            case SIMPLIFIED: {
                u = (float)humidity.m_207386_((DensityFunction.FunctionContext)context);
                if (!((double)y <= underground_line) || !randomize_underground) break;
                u = random_u * f1 + u * f2;
                break;
            }
            case LINEAR: {
                u = (float)humidity.m_207386_((DensityFunction.FunctionContext)context);
                if (!((double)y <= underground_line) || !randomize_underground) break;
                u = random_u * f1 + u * f2;
                break;
            }
            default: {
                boolean underJungle2 = false;
                if (a == 0.0) {
                    u = -1.0;
                } else if (mad_z >= SavannaStart && mad_z <= DesertStart || mad_z >= SavannaStart2 && mad_z <= TempStart2) {
                    u = -1.0;
                } else if (mad_z >= JungleStart && mad_z <= DesertStart2) {
                    u = Math.signum(Math.cos(Math.PI * 2 * adjustedZ / a));
                    underJungle2 = true;
                } else {
                    u = mad_z >= PoleStart2 && mad_z <= ColdStart3 ? -1.0 : (double)((float)humidity.m_207386_((DensityFunction.FunctionContext)context));
                }
                if (!s && (zp >= SPoleWaveZ || zp <= NPoleWaveZ)) {
                    u = -1.0;
                }
                if (!((double)y <= underground_line) || !randomize_underground || underJungle2) break;
                u = random_u * f1 + u * f2;
            }
        }
        return (float)u;
    }
}

