/*
 * Decompiled with CFR 0.152.
 */
package naturaltemperature.mixin;

import naturaltemperature.NaturalTemperature;
import naturaltemperature.NoiseBiomeBandsGenerator;
import naturaltemperature.WorldSeedHolder;
import naturaltemperature.mixin.MultiNoiseSamplerAccessor;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6910;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_6544.class_6552.class})
public class TemperatureMixin {
    private final NoiseBiomeBandsGenerator noiseGenerator = new NoiseBiomeBandsGenerator(WorldSeedHolder.getSeed());

    @Inject(method={"sample"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyTemperature(int x, int y, int z, CallbackInfoReturnable<class_6544.class_6553> cir) {
        int i = class_5742.method_33101((int)x);
        int j = class_5742.method_33101((int)y);
        int k = class_5742.method_33101((int)z);
        class_6910.class_6914 unblendedNoisePos = new class_6910.class_6914(i, j, k);
        MultiNoiseSamplerAccessor accessor = (MultiNoiseSamplerAccessor)((Object)this);
        class_6910 continentalness = accessor.getContinentalness();
        class_6910 erosion = accessor.getErosion();
        class_6910 depth = accessor.getDepth();
        class_6910 weirdness = accessor.getWeirdness();
        float customTemperature = this.customTemperatureCalculation(i, j, k);
        float customHumidity = this.customHumidityCalculation(i, j, k);
        float continentalnessValue = (float)continentalness.method_40464((class_6910.class_6912)unblendedNoisePos);
        float erosionValue = (float)erosion.method_40464((class_6910.class_6912)unblendedNoisePos);
        float depthValue = (float)depth.method_40464((class_6910.class_6912)unblendedNoisePos);
        float weirdnessValue = (float)weirdness.method_40464((class_6910.class_6912)unblendedNoisePos);
        class_6544.class_6553 newNoiseValuePoint = class_6544.method_38116((float)customTemperature, (float)customHumidity, (float)continentalnessValue, (float)erosionValue, (float)depthValue, (float)weirdnessValue);
        cir.setReturnValue((Object)newNoiseValuePoint);
    }

    private float customTemperatureCalculation(int x, int y, int z) {
        double a = NaturalTemperature.CONFIG.equatorial_distance;
        boolean s = NaturalTemperature.CONFIG.looping_world;
        double scale = 1.0;
        double distortionAmplitude = 30.0;
        double waveFrequency = 0.01;
        double waveAmplitude = 20.0;
        double noise = this.noiseGenerator.getNoise(x, z, scale);
        double wave = Math.sin((double)x * waveFrequency) * waveAmplitude;
        double adjustedZ = (double)z + noise * distortionAmplitude + wave;
        double t = !s ? (a == 0.0 ? -1.0 : ((double)z >= -a && (double)z <= 3.0 * a ? 0.6366197723675814 * Math.asin(Math.sin(Math.PI * adjustedZ / (2.0 * a))) : -1.0)) : (a == 0.0 ? -1.0 : 0.6366197723675814 * Math.asin(Math.sin(Math.PI * adjustedZ / (2.0 * a))));
        return (float)t;
    }

    private float customHumidityCalculation(int x, int y, int z) {
        class_6910.class_6914 unblendedNoisePos = new class_6910.class_6914(x, y, z);
        class_6910 humidity = ((MultiNoiseSamplerAccessor)((Object)this)).getHumidity();
        double a = NaturalTemperature.CONFIG.equatorial_distance;
        boolean s = NaturalTemperature.CONFIG.looping_world;
        double scale = 1.0;
        double distortionAmplitude = 30.0;
        double waveFrequency = 0.01;
        double waveAmplitude = 20.0;
        double noise = this.noiseGenerator.getNoise(x, z, scale);
        double wave = Math.sin((double)x * waveFrequency) * waveAmplitude;
        double NPoleWaveZ = noise * distortionAmplitude + wave - a;
        double SPoleWaveZ = noise * distortionAmplitude + wave + 3.0 * a;
        double u = !s ? (a == 0.0 ? -1.0 : ((double)z >= SPoleWaveZ || (double)z <= NPoleWaveZ ? -1.0 : (double)((float)humidity.method_40464((class_6910.class_6912)unblendedNoisePos)))) : (double)((float)humidity.method_40464((class_6910.class_6912)unblendedNoisePos));
        return (float)u;
    }
}

