/*
 * Decompiled with CFR 0.152.
 */
package naturaltemperature;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import naturaltemperature.ModConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaturalTemperature
implements ModInitializer {
    public static final String MOD_ID = "natural-temperature";
    public static MinecraftServer SERVER;
    public static ModConfig CONFIG;
    private static final Gson GSON;
    private static final File CONFIG_FILE;
    public static final Logger LOGGER;

    public void onInitialize() {
        LOGGER.info("NaturalTemperature Loaded");
        this.loadConfig();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SERVER = server;
        });
    }

    private void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                CONFIG = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                CONFIG = new ModConfig();
            }
        } else {
            CONFIG = new ModConfig();
            this.saveConfig();
        }
    }

    private void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)CONFIG, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "natural-temperature.json");
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

