/*
 * Decompiled with CFR 0.152.
 */
package naturaltemperature.mixin;

import naturaltemperature.GenMode;
import naturaltemperature.NaturalTemperature;
import naturaltemperature.NoiseBiomeBandsGenerator;
import naturaltemperature.WorldSeedHolder;
import naturaltemperature.mixin.MultiNoiseSamplerAccessor;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6910;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_6544.class_6552.class})
public class TemperatureMixin {
    private final NoiseBiomeBandsGenerator noiseGenerator = new NoiseBiomeBandsGenerator(WorldSeedHolder.getSeed());

    @Inject(method={"sample"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyTemperature(int x, int y, int z, CallbackInfoReturnable<class_6544.class_6553> cir) {
        int i = class_5742.method_33101((int)x);
        int j = class_5742.method_33101((int)y);
        int k = class_5742.method_33101((int)z);
        class_6910.class_6914 unblendedNoisePos = new class_6910.class_6914(i, j, k);
        MultiNoiseSamplerAccessor accessor = (MultiNoiseSamplerAccessor)((Object)this);
        class_6910 continentalness = accessor.getContinentalness();
        class_6910 erosion = accessor.getErosion();
        class_6910 depth = accessor.getDepth();
        class_6910 weirdness = accessor.getWeirdness();
        float customTemperature = this.customTemperatureCalculation(i, j, k);
        float customHumidity = this.customHumidityCalculation(i, j, k);
        float continentalnessValue = (float)continentalness.method_40464((class_6910.class_6912)unblendedNoisePos);
        float erosionValue = (float)erosion.method_40464((class_6910.class_6912)unblendedNoisePos);
        float depthValue = (float)depth.method_40464((class_6910.class_6912)unblendedNoisePos);
        float weirdnessValue = (float)weirdness.method_40464((class_6910.class_6912)unblendedNoisePos);
        class_6544.class_6553 newNoiseValuePoint = class_6544.method_38116((float)customTemperature, (float)customHumidity, (float)continentalnessValue, (float)erosionValue, (float)depthValue, (float)weirdnessValue);
        cir.setReturnValue((Object)newNoiseValuePoint);
    }

    private float customTemperatureCalculation(int x, int y, int z) {
        class_6910.class_6914 unblendedNoisePos = new class_6910.class_6914(x, y, z);
        class_6910 temperature = ((MultiNoiseSamplerAccessor)((Object)this)).getTemperature();
        double a = NaturalTemperature.CONFIG.equatorial_distance;
        boolean s = NaturalTemperature.CONFIG.looping_world;
        int m = NaturalTemperature.CONFIG.generation_mode;
        double offset = NaturalTemperature.CONFIG.equator_offset;
        double scale = 6.0;
        double distortionAmplitude = 30.0;
        double waveFrequency = 0.01;
        double waveAmplitude = 30.0;
        double noise = this.noiseGenerator.getNoise(x, z, scale);
        double wave = Math.sin((double)x * waveFrequency) * waveAmplitude;
        double adjustedZ = (double)z + noise * distortionAmplitude + wave + offset;
        double mod = 4.0 * a;
        double mad_z = (((double)z + offset + noise * distortionAmplitude + wave) % mod + mod) % mod;
        double zp = (double)z + offset;
        boolean randomize_underground = NaturalTemperature.CONFIG.randomize_underground;
        double underground_line = NaturalTemperature.CONFIG.randomize_underground_below_y;
        int underground_randomization_type = NaturalTemperature.CONFIG.underground_randomization_type;
        double globalTemperatureModifier = NaturalTemperature.CONFIG.global_temperature_modifier_percentage / 100.0;
        double globalMitigation = 1.0 - Math.abs(NaturalTemperature.CONFIG.global_mitigation_percentage / 100.0);
        double random_t = (float)temperature.method_40464((class_6910.class_6912)unblendedNoisePos);
        double f1 = 0.0;
        double f2 = 0.0;
        if (underground_randomization_type == 0) {
            f1 = 1.0;
            f2 = 0.0;
        } else if (underground_randomization_type == 1) {
            f1 = 0.75;
            f2 = 0.25;
        }
        double SavannaStart = 0.0;
        double JungleStart = 0.6666666666666666 * a;
        double DesertStart2 = 1.3333333333333333 * a;
        double t = 1.0;
        switch (switch (m) {
            case 2 -> GenMode.LINEAR;
            case 1 -> GenMode.SIMPLIFIED;
            default -> GenMode.DEFAULT;
        }) {
            case DEFAULT: {
                if (a == 0.0) {
                    t = -1.0;
                } else if (mad_z >= SavannaStart && mad_z <= JungleStart || mad_z >= DesertStart2 && mad_z <= 4.0 * a) {
                    t = 0.7639437268410976 * Math.asin(Math.sin(Math.PI * adjustedZ / (2.0 * a))) + 0.2;
                    t = Math.max(Math.min(1.0, t * globalMitigation + globalTemperatureModifier), -1.0);
                } else {
                    t = mad_z > JungleStart && mad_z < DesertStart2 ? 2.0 * Math.tanh(2.5 * Math.cos(Math.PI * adjustedZ / a)) + 2.3 : -1.0;
                }
                if (!s && (zp <= -1.0 * a || zp >= 3.0 * a)) {
                    t = -1.0;
                }
                if (!((double)y <= underground_line) || !randomize_underground) break;
                t = random_t * f1 + t * f2;
                break;
            }
            case SIMPLIFIED: {
                if (!s) {
                    if (a == 0.0) {
                        t = -1.0;
                    } else if (zp >= -a && zp <= 3.0 * a) {
                        t = 0.6366197723675814 * Math.asin(Math.sin(Math.PI * adjustedZ / (2.0 * a)));
                        t = Math.max(Math.min(1.0, t * globalMitigation + globalTemperatureModifier), -1.0);
                    } else {
                        t = -1.0;
                    }
                } else if (a == 0.0) {
                    t = -1.0;
                } else {
                    t = 0.6366197723675814 * Math.asin(Math.sin(Math.PI * adjustedZ / (2.0 * a)));
                    t = Math.max(Math.min(1.0, t * globalMitigation + globalTemperatureModifier), -1.0);
                }
                if (!((double)y <= underground_line) || !randomize_underground) break;
                t = random_t * f1 + t * f2;
                break;
            }
            case LINEAR: {
                t = Math.max(Math.min(1.0, 1.0 / a * adjustedZ), -1.0);
                t = Math.max(Math.min(1.0, t * globalMitigation + globalTemperatureModifier), -1.0);
                if (!((double)y <= underground_line) || !randomize_underground) break;
                t = random_t * f1 + t * f2;
                break;
            }
            default: {
                if (a == 0.0) {
                    t = -1.0;
                } else if (mad_z >= SavannaStart && mad_z <= JungleStart || mad_z >= DesertStart2 && mad_z <= 4.0 * a) {
                    t = 0.7639437268410976 * Math.asin(Math.sin(Math.PI * adjustedZ / (2.0 * a))) + 0.2;
                    t = Math.max(Math.min(1.0, (t + globalTemperatureModifier) * globalMitigation), -1.0);
                } else {
                    t = mad_z > JungleStart && mad_z < DesertStart2 ? 2.0 * Math.tanh(2.5 * Math.cos(Math.PI * adjustedZ / a)) + 2.3 : -1.0;
                }
                if (!s && (zp <= -1.0 * a || zp >= 3.0 * a)) {
                    t = -1.0;
                }
                if (!((double)y <= underground_line) || !randomize_underground) break;
                t = random_t * f1 + t * f2;
            }
        }
        return (float)t;
    }

    private float customHumidityCalculation(int x, int y, int z) {
        double u;
        class_6910.class_6914 unblendedNoisePos = new class_6910.class_6914(x, y, z);
        class_6910 humidity = ((MultiNoiseSamplerAccessor)((Object)this)).getHumidity();
        double a = NaturalTemperature.CONFIG.equatorial_distance;
        boolean s = NaturalTemperature.CONFIG.looping_world;
        int m = NaturalTemperature.CONFIG.generation_mode;
        double offset = NaturalTemperature.CONFIG.equator_offset;
        double scale = 6.0;
        double distortionAmplitude = 30.0;
        double waveFrequency = 0.01;
        double waveAmplitude = 30.0;
        double noise = this.noiseGenerator.getNoise(x, z, scale);
        double wave = Math.sin((double)x * waveFrequency) * waveAmplitude;
        double mod = 4.0 * a;
        double mad_z = (((double)z + offset + noise * distortionAmplitude + wave) % mod + mod) % mod;
        double adjustedZ = (double)z + noise * distortionAmplitude + wave + offset;
        double zp = (double)z + offset;
        double NPoleWaveZ = noise * distortionAmplitude + wave - 1.0 * a;
        double SPoleWaveZ = noise * distortionAmplitude + wave + 3.0 * a;
        double JungleStart = 0.6666666666666666 * a;
        double DesertStart2 = 1.3333333333333333 * a;
        double SavannaStart = 0.0;
        double DesertStart = 0.3333333333333333 * a;
        double SavannaStart2 = 1.6666666666666667 * a;
        double PoleStart2 = 2.6666666666666665 * a;
        double ColdStart3 = 3.3333333333333335 * a;
        double TempStart2 = 2.0 * a;
        boolean randomize_underground = NaturalTemperature.CONFIG.randomize_underground;
        double underground_line = NaturalTemperature.CONFIG.randomize_underground_below_y;
        double random_u = (float)humidity.method_40464((class_6910.class_6912)unblendedNoisePos);
        double f1 = 1.0;
        double f2 = 0.0;
        float t = this.customTemperatureCalculation(x, y, z);
        switch (switch (m) {
            case 2 -> GenMode.LINEAR;
            case 1 -> GenMode.SIMPLIFIED;
            default -> GenMode.DEFAULT;
        }) {
            case DEFAULT: {
                if (a == 0.0) {
                    u = -1.0;
                } else if (mad_z >= SavannaStart && mad_z <= DesertStart || mad_z >= SavannaStart2 && mad_z <= TempStart2) {
                    u = -1.0;
                    if ((double)y <= underground_line && randomize_underground) {
                        u = random_u * f1 + u * f2;
                    }
                } else if (mad_z >= JungleStart && mad_z <= DesertStart2) {
                    u = Math.signum(Math.cos(Math.PI * 2 * adjustedZ / a));
                } else if (mad_z >= PoleStart2 && mad_z <= ColdStart3) {
                    u = -1.0;
                    if ((double)y <= underground_line && randomize_underground) {
                        u = random_u * f1 + u * f2;
                    }
                } else if (mad_z >= DesertStart && mad_z <= JungleStart || mad_z >= DesertStart2 && mad_z <= SavannaStart2) {
                    u = (double)t <= 0.65 ? -1.0 : (double)((float)humidity.method_40464((class_6910.class_6912)unblendedNoisePos));
                } else {
                    u = (float)humidity.method_40464((class_6910.class_6912)unblendedNoisePos);
                    if ((double)y <= underground_line && randomize_underground) {
                        u = random_u * f1 + u * f2;
                    }
                }
                if (s || !(zp >= SPoleWaveZ) && !(zp <= NPoleWaveZ)) break;
                u = -1.0;
                if (!((double)y <= underground_line) || !randomize_underground) break;
                u = random_u * f1 + u * f2;
                break;
            }
            case SIMPLIFIED: {
                u = (float)humidity.method_40464((class_6910.class_6912)unblendedNoisePos);
                if (!((double)y <= underground_line) || !randomize_underground) break;
                u = random_u * f1 + u * f2;
                break;
            }
            case LINEAR: {
                u = (float)humidity.method_40464((class_6910.class_6912)unblendedNoisePos);
                if (!((double)y <= underground_line) || !randomize_underground) break;
                u = random_u * f1 + u * f2;
                break;
            }
            default: {
                u = a == 0.0 ? -1.0 : (mad_z >= SavannaStart && mad_z <= DesertStart || mad_z >= SavannaStart2 && mad_z <= TempStart2 ? -1.0 : (mad_z >= JungleStart && mad_z <= DesertStart2 ? Math.signum(Math.cos(Math.PI * 2 * adjustedZ / a)) : (mad_z >= PoleStart2 && mad_z <= ColdStart3 ? -1.0 : (double)((float)humidity.method_40464((class_6910.class_6912)unblendedNoisePos)))));
                if (!s && (zp >= SPoleWaveZ || zp <= NPoleWaveZ)) {
                    u = -1.0;
                }
                if (!((double)y <= underground_line) || !randomize_underground) break;
                u = random_u * f1 + u * f2;
            }
        }
        return (float)u;
    }
}

