/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scorchingmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.scorchingmod.client.model.Modelmummy;
import net.mcreator.scorchingmod.client.model.animations.mummyAnimation;
import net.mcreator.scorchingmod.entity.CursedCorpseEntity;
import net.mcreator.scorchingmod.procedures.CursedCorpseWoundDisplayCondition1Procedure;
import net.mcreator.scorchingmod.procedures.CursedCorpseWoundDisplayCondition2Procedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class CursedCorpseRenderer
extends MobRenderer<CursedCorpseEntity, LivingEntityRenderState, Modelmummy> {
    private CursedCorpseEntity entity = null;

    public CursedCorpseRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelmummy.LAYER_LOCATION)), 0.8f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelmummy>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"scorchingmod:textures/entities/mummy_eyes.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((Modelmummy)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelmummy>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"scorchingmod:textures/entities/mummy_wound_1.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = CursedCorpseRenderer.this.entity.level();
                double x = CursedCorpseRenderer.this.entity.getX();
                double y = CursedCorpseRenderer.this.entity.getY();
                double z = CursedCorpseRenderer.this.entity.getZ();
                if (CursedCorpseWoundDisplayCondition1Procedure.execute((Entity)CursedCorpseRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelmummy)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelmummy>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"scorchingmod:textures/entities/mummy_wound_2.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = CursedCorpseRenderer.this.entity.level();
                double x = CursedCorpseRenderer.this.entity.getX();
                double y = CursedCorpseRenderer.this.entity.getY();
                double z = CursedCorpseRenderer.this.entity.getZ();
                if (CursedCorpseWoundDisplayCondition2Procedure.execute((Entity)CursedCorpseRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelmummy)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(CursedCorpseEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"scorchingmod:textures/entities/mummy_irongolem_skin.png");
    }

    private static final class AnimatedModel
    extends Modelmummy {
        private CursedCorpseEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(CursedCorpseEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, mummyAnimation.Awaken, state.ageInTicks, 1.0f);
            this.animateWalk(mummyAnimation.Walk, state.walkAnimationPos, state.walkAnimationSpeed, 1.2f, 1.3f);
            this.animate(this.entity.animationState2, mummyAnimation.Idle, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

