/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scorchingmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.scorchingmod.client.model.ModelduneCreeper;
import net.mcreator.scorchingmod.client.model.animations.duneCreeperAnimation;
import net.mcreator.scorchingmod.entity.DuneCreeperEntity;
import net.mcreator.scorchingmod.procedures.IsCreeperSwellingProcedure;
import net.mcreator.scorchingmod.procedures.IsEntityAggressiveProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class DuneCreeperRenderer
extends MobRenderer<DuneCreeperEntity, LivingEntityRenderState, ModelduneCreeper> {
    private DuneCreeperEntity entity = null;

    public DuneCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelduneCreeper.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, ModelduneCreeper>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"scorchingmod:textures/entities/dune_creeper_emission.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = DuneCreeperRenderer.this.entity.level();
                double x = DuneCreeperRenderer.this.entity.getX();
                double y = DuneCreeperRenderer.this.entity.getY();
                double z = DuneCreeperRenderer.this.entity.getZ();
                if (IsEntityAggressiveProcedure.execute((Entity)DuneCreeperRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelduneCreeper)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(DuneCreeperEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"scorchingmod:textures/entities/dune_creeper_texture.png");
    }

    protected boolean isShaking(LivingEntityRenderState state) {
        Level world = this.entity.level();
        double x = this.entity.getX();
        double y = this.entity.getY();
        double z = this.entity.getZ();
        return IsCreeperSwellingProcedure.execute((Entity)this.entity);
    }

    private static final class AnimatedModel
    extends ModelduneCreeper {
        private DuneCreeperEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(DuneCreeperEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animateWalk(duneCreeperAnimation.walk, state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            this.animate(this.entity.animationState1, duneCreeperAnimation.Idle, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

