/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scorchingmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.scorchingmod.entity.LavaCreeperEntity;
import net.mcreator.scorchingmod.procedures.IsCreeperSwellingProcedure;
import net.mcreator.scorchingmod.procedures.IsEntityAggressiveProcedure;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class LavaCreeperRenderer
extends MobRenderer<LavaCreeperEntity, CreeperRenderState, CreeperModel> {
    private LavaCreeperEntity entity = null;

    public LavaCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CreeperModel(context.bakeLayer(ModelLayers.CREEPER)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<CreeperRenderState, CreeperModel>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"scorchingmod:textures/entities/lavacreeper_emission_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, CreeperRenderState state, float headYaw, float headPitch) {
                Level world = LavaCreeperRenderer.this.entity.level();
                double x = LavaCreeperRenderer.this.entity.getX();
                double y = LavaCreeperRenderer.this.entity.getY();
                double z = LavaCreeperRenderer.this.entity.getZ();
                if (IsEntityAggressiveProcedure.execute((Entity)LavaCreeperRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                    ((CreeperModel)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public CreeperRenderState createRenderState() {
        return new CreeperRenderState();
    }

    public void extractRenderState(LavaCreeperEntity entity, CreeperRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        this.entity = entity;
    }

    public ResourceLocation getTextureLocation(CreeperRenderState state) {
        return ResourceLocation.parse((String)"scorchingmod:textures/entities/lavacreeper_texture.png");
    }

    protected boolean isShaking(CreeperRenderState state) {
        Level world = this.entity.level();
        double x = this.entity.getX();
        double y = this.entity.getY();
        double z = this.entity.getZ();
        return IsCreeperSwellingProcedure.execute((Entity)this.entity);
    }
}

