/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scorchingmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.scorchingmod.client.model.Modelthemelted;
import net.mcreator.scorchingmod.client.model.animations.themeltedAnimation;
import net.mcreator.scorchingmod.entity.TheMeltedEntity;
import net.mcreator.scorchingmod.procedures.TheMeltedEntityScaleProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class TheMeltedRenderer
extends MobRenderer<TheMeltedEntity, LivingEntityRenderState, Modelthemelted> {
    private TheMeltedEntity entity = null;

    public TheMeltedRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelthemelted.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelthemelted>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"scorchingmod:textures/entities/themeltedhusk_emission_texture.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((Modelthemelted)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(TheMeltedEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"scorchingmod:textures/entities/themeltedhusktexture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        Level world = this.entity.level();
        double x = this.entity.getX();
        double y = this.entity.getY();
        double z = this.entity.getZ();
        float scale = (float)TheMeltedEntityScaleProcedure.execute((Entity)this.entity);
        poseStack.scale(scale, scale, scale);
    }

    private static final class AnimatedModel
    extends Modelthemelted {
        private TheMeltedEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(TheMeltedEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, themeltedAnimation.Awaken, state.ageInTicks, 1.0f);
            this.animateWalk(themeltedAnimation.TweakedCrawlAnimation, state.walkAnimationPos, state.walkAnimationSpeed, 2.0f, 2.0f);
            this.animate(this.entity.animationState2, themeltedAnimation.Idle, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

