/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scorchingmod.item;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import net.mcreator.scorchingmod.client.model.ModelinferniumArmor;
import net.mcreator.scorchingmod.init.ScorchingmodModItems;
import net.mcreator.scorchingmod.procedures.InferniumArmorBootsTickEventProcedure;
import net.mcreator.scorchingmod.procedures.InferniumArmorChestplateTickEventProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class InferniumArmorItem
extends ArmorItem {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(15, Map.of(ArmorType.BOOTS, 4, ArmorType.LEGGINGS, 8, ArmorType.CHESTPLATE, 15, ArmorType.HELMET, 9, ArmorType.BODY, 15), 12, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_netherite")), 3.0f, 0.05f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"scorchingmod:infernium_armor_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"scorchingmod:infernium_armor")));

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Model original) {
                return new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new ModelPart(Collections.emptyList(), Map.of("head", new ModelinferniumArmor((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)ModelinferniumArmor.LAYER_LOCATION)).Head, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()))), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
            }

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"scorchingmod:textures/entities/inferniumarmormain.png");
            }
        }, new Item[]{(Item)ScorchingmodModItems.INFERNIUM_ARMOR_HELMET.get()});
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Model original) {
                return new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new ModelinferniumArmor((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)ModelinferniumArmor.LAYER_LOCATION)).Body, "left_arm", new ModelinferniumArmor((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)ModelinferniumArmor.LAYER_LOCATION)).LeftArm, "right_arm", new ModelinferniumArmor((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)ModelinferniumArmor.LAYER_LOCATION)).RightArm, "head", new ModelPart(Collections.emptyList(), Map.of("hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()))), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
            }

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"scorchingmod:textures/entities/inferniumarmormain.png");
            }
        }, new Item[]{(Item)ScorchingmodModItems.INFERNIUM_ARMOR_CHESTPLATE.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"scorchingmod:textures/entities/inferniumarmorleggings.png");
            }
        }, new Item[]{(Item)ScorchingmodModItems.INFERNIUM_ARMOR_LEGGINGS.get()});
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Model original) {
                return new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new ModelinferniumArmor((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)ModelinferniumArmor.LAYER_LOCATION)).LeftLeg, "right_leg", new ModelinferniumArmor((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)ModelinferniumArmor.LAYER_LOCATION)).RightLeg, "head", new ModelPart(Collections.emptyList(), Map.of("hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()))), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
            }

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"scorchingmod:textures/entities/inferniumarmormain.png");
            }
        }, new Item[]{(Item)ScorchingmodModItems.INFERNIUM_ARMOR_BOOTS.get()});
    }

    private InferniumArmorItem(ArmorType type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends InferniumArmorItem {
        public Boots(Item.Properties properties) {
            super(ArmorType.BOOTS, properties.fireResistant());
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                InferniumArmorBootsTickEventProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
            }
        }
    }

    public static class Leggings
    extends InferniumArmorItem {
        public Leggings(Item.Properties properties) {
            super(ArmorType.LEGGINGS, properties.fireResistant());
        }
    }

    public static class Chestplate
    extends InferniumArmorItem {
        public Chestplate(Item.Properties properties) {
            super(ArmorType.CHESTPLATE, properties.fireResistant());
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                InferniumArmorChestplateTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Helmet
    extends InferniumArmorItem {
        public Helmet(Item.Properties properties) {
            super(ArmorType.HELMET, properties.fireResistant());
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }
}

