/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins;

import com.iafenvoy.origins.Origins;
import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.layer.Layer;
import com.iafenvoy.origins.data.layer.LayerRegistries;
import com.iafenvoy.origins.data.origin.Origin;
import com.iafenvoy.origins.data.origin.OriginRegistries;
import com.iafenvoy.origins.network.LoginHelper;
import com.iafenvoy.origins.util.RLHelper;
import com.iafenvoy.origins.util.RandomHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber
public class OriginsCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandBuildContext context = event.getBuildContext();
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"origins").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"layer", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, LayerRegistries.LAYER_KEY)).then(Commands.argument((String)"origin", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, OriginRegistries.ORIGIN_KEY)).executes(OriginsCommand::set)))))).then(Commands.literal((String)"get").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"layer", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, LayerRegistries.LAYER_KEY)).executes(OriginsCommand::get))))).then(((LiteralArgumentBuilder)Commands.literal((String)"gui").executes(ctx -> OriginsCommand.openGuiAll((CommandContext<CommandSourceStack>)ctx, true))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> OriginsCommand.openGuiAll((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.argument((String)"layer", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, LayerRegistries.LAYER_KEY)).executes(OriginsCommand::openGuiSpecific))))).then(((LiteralArgumentBuilder)Commands.literal((String)"random").executes(ctx -> OriginsCommand.randomAll((CommandContext<CommandSourceStack>)ctx, true))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> OriginsCommand.randomAll((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.argument((String)"layer", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, LayerRegistries.LAYER_KEY)).executes(OriginsCommand::randomSpecific)))));
    }

    public static int set(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ObjectArrayList targets = new ObjectArrayList(EntityArgument.getPlayers(context, (String)"targets"));
        Holder.Reference layer = ResourceArgument.getResource(context, (String)"layer", LayerRegistries.LAYER_KEY);
        Holder.Reference origin = ResourceArgument.getResource(context, (String)"origin", OriginRegistries.ORIGIN_KEY);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int processedTargets = 0;
        if (((Origin)origin.value()).equals(Origin.EMPTY) || origin.is(((Layer)layer.value()).origins())) {
            for (ServerPlayer target : targets) {
                EntityOriginAttachment originComponent = EntityOriginAttachment.get((Entity)target);
                originComponent.setOrigin((Holder<Layer>)layer, (Holder<Origin>)origin, (Entity)target);
                originComponent.sync((Entity)target);
                ++processedTargets;
            }
            if (processedTargets == 1) {
                source.sendSuccess(() -> OriginsCommand.lambda$set$5((List)targets, (Holder)layer, (Holder)origin), true);
            } else {
                int finalProcessedTargets = processedTargets;
                source.sendSuccess(() -> OriginsCommand.lambda$set$6(finalProcessedTargets, (Holder)layer, (Holder)origin), true);
            }
        } else {
            source.sendFailure((Component)Component.translatableEscape((String)"commands.origin.unregistered_in_layer", (Object[])new Object[]{RLHelper.string(origin), RLHelper.string(layer)}));
        }
        return processedTargets;
    }

    public static int get(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        Holder.Reference layer = ResourceArgument.getResource(context, (String)"layer", LayerRegistries.LAYER_KEY);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        EntityOriginAttachment originComponent = EntityOriginAttachment.get((Entity)target);
        Holder<Origin> origin = originComponent.getOrigin((Holder<Layer>)layer);
        source.sendSuccess(() -> OriginsCommand.lambda$get$7(target, (Holder)layer, origin), false);
        return 1;
    }

    public static int openGuiAll(CommandContext<CommandSourceStack> context, boolean self) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection<Object> targets = self ? List.of(source.getPlayerOrException()) : EntityArgument.getPlayers(context, (String)"targets");
        for (ServerPlayer serverPlayer : targets) {
            LoginHelper.openGuiForLayer(serverPlayer, null);
        }
        source.sendSuccess(() -> Component.translatable((String)"commands.origin.gui.all", (Object[])new Object[]{targets.size()}), true);
        return targets.size();
    }

    public static int openGuiSpecific(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(context, (String)"targets");
        Holder.Reference layer = ResourceArgument.getResource(context, (String)"layer", LayerRegistries.LAYER_KEY);
        for (ServerPlayer target : targets) {
            LoginHelper.openGuiForLayer(target, (Holder<Layer>)layer);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> OriginsCommand.lambda$openGuiSpecific$9(targets, (Holder)layer), true);
        return targets.size();
    }

    public static int randomAll(CommandContext<CommandSourceStack> context, boolean self) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection<Object> targets = self ? List.of(source.getPlayerOrException()) : EntityArgument.getPlayers(context, (String)"targets");
        List<Holder<Layer>> layers = LayerRegistries.streamRandomizableLayers(((CommandSourceStack)context.getSource()).registryAccess()).toList();
        for (ServerPlayer serverPlayer : targets) {
            for (Holder<Layer> layer : layers) {
                OriginsCommand.setAndGetRandomOrigin(serverPlayer, layer);
            }
        }
        source.sendSuccess(() -> Component.translatable((String)"commands.origin.random.all", (Object[])new Object[]{targets.size(), layers.size()}), true);
        return targets.size();
    }

    public static int randomSpecific(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ObjectArrayList targets = new ObjectArrayList(EntityArgument.getPlayers(context, (String)"targets"));
        Holder.Reference layer = ResourceArgument.getResource(context, (String)"layer", LayerRegistries.LAYER_KEY);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        AtomicReference<Holder<Origin>> origin = new AtomicReference<Holder<Origin>>();
        if (((Layer)layer.value()).allowRandom()) {
            for (ServerPlayer target : targets) {
                origin.set(OriginsCommand.setAndGetRandomOrigin(target, (Holder<Layer>)layer));
            }
            if (targets.size() > 1) {
                source.sendSuccess(() -> OriginsCommand.lambda$randomSpecific$11((List)targets, (Holder)layer), true);
            } else {
                source.sendSuccess(() -> OriginsCommand.lambda$randomSpecific$12((List)targets, origin, (Holder)layer), true);
            }
        }
        return targets.size();
    }

    private static Holder<Origin> setAndGetRandomOrigin(ServerPlayer target, Holder<Layer> layer) {
        List<Holder<Origin>> origins = ((Layer)layer.value()).collectRandomizableOrigins(target.registryAccess()).toList();
        EntityOriginAttachment originComponent = EntityOriginAttachment.get((Entity)target);
        Holder<Origin> origin = RandomHelper.randomOne(origins);
        originComponent.setOrigin(layer, origin, (Entity)target);
        originComponent.fillAutoChoosing((Entity)target);
        originComponent.sync((Entity)target);
        Origins.LOGGER.info("Player {} was randomly assigned the origin {} for layer {}", new Object[]{target.getName().getString(), RLHelper.id(origin), RLHelper.id(layer)});
        return origin;
    }

    private static /* synthetic */ Component lambda$randomSpecific$12(List targets, AtomicReference origin, Holder layer) {
        return Component.translatable((String)"commands.origin.random.success.single", (Object[])new Object[]{((ServerPlayer)targets.getFirst()).getName(), Origin.getName((Holder<Origin>)((Holder)origin.get())), Layer.getName((Holder<Layer>)layer)});
    }

    private static /* synthetic */ Component lambda$randomSpecific$11(List targets, Holder layer) {
        return Component.translatable((String)"commands.origin.random.success.multiple", (Object[])new Object[]{targets.size(), Layer.getName((Holder<Layer>)layer)});
    }

    private static /* synthetic */ Component lambda$openGuiSpecific$9(Collection targets, Holder layer) {
        return Component.translatable((String)"commands.origin.gui.layer", (Object[])new Object[]{targets.size(), Layer.getName((Holder<Layer>)layer)});
    }

    private static /* synthetic */ Component lambda$get$7(ServerPlayer target, Holder layer, Holder origin) {
        return Component.translatable((String)"commands.origin.get.result", (Object[])new Object[]{target.getName(), Layer.getName((Holder<Layer>)layer), Origin.getName((Holder<Origin>)origin), RLHelper.string(origin)});
    }

    private static /* synthetic */ Component lambda$set$6(int finalProcessedTargets, Holder layer, Holder origin) {
        return Component.translatable((String)"commands.origin.set.success.multiple", (Object[])new Object[]{finalProcessedTargets, Layer.getName((Holder<Layer>)layer), Origin.getName((Holder<Origin>)origin)});
    }

    private static /* synthetic */ Component lambda$set$5(List targets, Holder layer, Holder origin) {
        return Component.translatable((String)"commands.origin.set.success.single", (Object[])new Object[]{((ServerPlayer)targets.getFirst()).getName(), Layer.getName((Holder<Layer>)layer), Origin.getName((Holder<Origin>)origin)});
    }
}

