/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.attachment;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.iafenvoy.origins.data.layer.Layer;
import com.iafenvoy.origins.data.layer.LayerRegistries;
import com.iafenvoy.origins.data.origin.Origin;
import com.iafenvoy.origins.data.power.Power;
import com.iafenvoy.origins.data.power.PowerRegistries;
import com.iafenvoy.origins.registry.OriginsAttachments;
import com.iafenvoy.origins.util.RandomHelper;
import com.iafenvoy.origins.util.codec.AutoIgnoreMapCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public final class EntityOriginAttachment {
    public static final Codec<Map<Holder<Layer>, Holder<Origin>>> ORIGINS_CODEC = new AutoIgnoreMapCodec<Holder<Layer>, Holder<Origin>>(Layer.CODEC, Origin.CODEC);
    public static final Codec<EntityOriginAttachment> CODEC = RecordCodecBuilder.create(i -> i.group((App)ORIGINS_CODEC.fieldOf("origin").forGetter(EntityOriginAttachment::getOrigins)).apply((Applicative)i, EntityOriginAttachment::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EntityOriginAttachment> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    private final Map<Holder<Layer>, Holder<Origin>> origins = new LinkedHashMap<Holder<Layer>, Holder<Origin>>();
    private boolean selecting = false;
    private final Multimap<ResourceLocation, Power> powerMap = HashMultimap.create();

    public EntityOriginAttachment() {
    }

    private EntityOriginAttachment(Map<Holder<Layer>, Holder<Origin>> origins) {
        this.origins.putAll(origins);
        this.refreshPowerMap();
    }

    public boolean isSelecting() {
        return this.selecting;
    }

    public void setSelecting(boolean selecting) {
        this.selecting = selecting;
    }

    public void setOrigin(@NotNull Holder<Layer> layer, @NotNull Holder<Origin> origin, @NotNull Entity entity) {
        this.clearOrigin(layer, entity);
        if (origin.value() == Origin.EMPTY) {
            return;
        }
        if (entity.level().isClientSide) {
            entity.sendSystemMessage((Component)Component.translatable((String)"commands.origin.set.success.single", (Object[])new Object[]{entity.getDisplayName(), Layer.getName(layer), Origin.getName(origin)}));
        }
        this.origins.put(layer, origin);
        this.refreshPowerMap();
        EntityOriginAttachment.executeOnPowers(origin, p -> p.grant(entity));
    }

    public void clearOrigin(@NotNull Holder<Layer> layer, @NotNull Entity entity) {
        EntityOriginAttachment.executeOnPowers(this.origins.remove(layer), p -> p.revoke(entity));
    }

    public void refreshPowerMap() {
        this.powerMap.clear();
        this.origins.values().forEach(o -> ((Origin)o.value()).powers().stream().map(Holder::value).forEach(p -> this.powerMap.put((Object)PowerRegistries.POWER_TYPE.getKey(p.codec()), p)));
    }

    public void tick(@NotNull Entity entity) {
        this.origins.values().forEach(o -> EntityOriginAttachment.executeOnPowers((Holder<Origin>)o, p -> p.tick(entity)));
    }

    private Map<Holder<Layer>, Holder<Origin>> getOrigins() {
        return this.origins;
    }

    public Map<Holder<Layer>, Holder<Origin>> getOriginsView() {
        return Map.copyOf(this.origins);
    }

    public Holder<Origin> getOrigin(Holder<Layer> layer) {
        return this.origins.get(layer);
    }

    @NotNull
    public <T extends Power> Collection<T> getPowers(DeferredHolder<MapCodec<? extends Power>, MapCodec<T>> holder, Class<T> clazz) {
        return this.getPowers(holder.getId(), clazz);
    }

    @NotNull
    public <T extends Power> List<T> getPowers(ResourceLocation id, Class<T> clazz) {
        LinkedList<Power> results = new LinkedList<Power>();
        for (Power power : this.powerMap.get((Object)id)) {
            if (power == null || !clazz.isAssignableFrom(power.getClass())) continue;
            results.add((Power)clazz.cast(power));
        }
        return results;
    }

    public boolean hasOrigin(Holder<Layer> layer) {
        return this.origins.containsKey(layer) && this.origins.get(layer).value() != Origin.EMPTY;
    }

    public void sync(Entity entity) {
        entity.syncData(OriginsAttachments.ENTITY_ORIGIN);
    }

    public boolean randomOrigin(Holder<Layer> layer, Entity entity) {
        List<Holder<Origin>> available = ((Layer)layer.value()).collectRandomizableOrigins(entity.registryAccess()).toList();
        if (!available.isEmpty()) {
            this.setOrigin(layer, RandomHelper.randomOne(available), entity);
            return true;
        }
        return false;
    }

    public boolean fillAutoChoosing(Entity entity) {
        boolean changed = false;
        List<Holder<Layer>> layers = LayerRegistries.streamAutoChooseLayers(entity.registryAccess()).toList();
        for (Holder<Layer> layer : layers) {
            if (this.origins.containsKey(layer)) continue;
            changed |= this.randomOrigin(layer, entity);
        }
        if (changed) {
            this.sync(entity);
        }
        return changed;
    }

    public boolean hasAllOrigins(RegistryAccess access) {
        List<Holder<Layer>> layers = LayerRegistries.streamAvailableLayers(access).toList();
        for (Holder<Layer> layer : layers) {
            if (this.origins.containsKey(layer)) continue;
            return false;
        }
        return true;
    }

    private static void executeOnPowers(@Nullable Holder<Origin> origin, Consumer<Power> consumer) {
        if (origin != null) {
            ((Origin)origin.value()).powers().stream().map(Holder::value).forEach(consumer);
        }
    }

    public static EntityOriginAttachment get(Entity entity) {
        return (EntityOriginAttachment)entity.getData(OriginsAttachments.ENTITY_ORIGIN);
    }

    @SubscribeEvent
    public static void refreshPowersWhenReload(OnDatapackSyncEvent event) {
        event.getRelevantPlayers().map(EntityOriginAttachment::get).forEach(EntityOriginAttachment::refreshPowerMap);
    }
}

