/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.bientity;

import com.iafenvoy.origins.data.action.BiEntityAction;
import com.iafenvoy.origins.util.Space;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record AddVelocityAction(float x, float y, float z, Reference reference, boolean client, boolean server, boolean set) implements BiEntityAction
{
    public static final MapCodec<AddVelocityAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.FLOAT.optionalFieldOf("x", (Object)Float.valueOf(0.0f)).forGetter(AddVelocityAction::x), (App)Codec.FLOAT.optionalFieldOf("y", (Object)Float.valueOf(0.0f)).forGetter(AddVelocityAction::y), (App)Codec.FLOAT.optionalFieldOf("z", (Object)Float.valueOf(0.0f)).forGetter(AddVelocityAction::z), (App)Reference.CODEC.optionalFieldOf("reference", (Object)Reference.POSITION).forGetter(AddVelocityAction::reference), (App)Codec.BOOL.optionalFieldOf("client", (Object)true).forGetter(AddVelocityAction::client), (App)Codec.BOOL.optionalFieldOf("server", (Object)true).forGetter(AddVelocityAction::server), (App)Codec.BOOL.optionalFieldOf("set", (Object)false).forGetter(AddVelocityAction::set)).apply((Applicative)i, AddVelocityAction::new));

    @Override
    @NotNull
    public MapCodec<? extends BiEntityAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Entity source, @NotNull Entity target) {
        Vector3f velocity = new Vector3f(this.x, this.y, this.z);
        Vec3 refVec = this.reference.apply(source, target);
        Space.transformVectorToBase(refVec, velocity, source.getYRot(), true);
        if (this.set) {
            target.setDeltaMovement(new Vec3(velocity));
        } else {
            target.addDeltaMovement(new Vec3(velocity));
        }
        target.hurtMarked = true;
    }

    public static enum Reference implements StringRepresentable
    {
        POSITION((actor, target) -> target.position().subtract(actor.position())),
        ROTATION((actor, target) -> {
            float pitch = actor.getXRot();
            float yaw = actor.getYRot();
            float i = (float)Math.PI / 180;
            float j = -Mth.sin((float)(yaw * i)) * Mth.cos((float)(pitch * i));
            float k = -Mth.sin((float)(pitch * i));
            float l = Mth.cos((float)(yaw * i)) * Mth.cos((float)(pitch * i));
            return new Vec3((double)j, (double)k, (double)l);
        });

        public static final Codec<Reference> CODEC;
        final BiFunction<Entity, Entity, Vec3> refFunction;

        private Reference(BiFunction<Entity, Entity, Vec3> refFunction) {
            this.refFunction = refFunction;
        }

        public Vec3 apply(Entity actor, Entity target) {
            return this.refFunction.apply(actor, target);
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Reference::values);
        }
    }
}

