/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.block;

import com.iafenvoy.origins.data.action.BlockAction;
import com.iafenvoy.origins.data.condition.BlockCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public record BlockExplodeAction(float power, DestructionType destructionType, Optional<BlockCondition> indestructible, boolean createFire) implements BlockAction
{
    public static final MapCodec<BlockExplodeAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.FLOAT.fieldOf("power").forGetter(BlockExplodeAction::power), (App)DestructionType.CODEC.optionalFieldOf("destruction_type", (Object)DestructionType.BREAK).forGetter(BlockExplodeAction::destructionType), (App)BlockCondition.CODEC.optionalFieldOf("indestructible").forGetter(BlockExplodeAction::indestructible), (App)Codec.BOOL.optionalFieldOf("create_fire", (Object)false).forGetter(BlockExplodeAction::createFire)).apply((Applicative)i, BlockExplodeAction::new));

    @Override
    @NotNull
    public MapCodec<? extends BlockAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(final @NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction) {
        if (level.isClientSide()) {
            return;
        }
        ExplosionDamageCalculator calculator = this.indestructible().isEmpty() ? new ExplosionDamageCalculator() : new ExplosionDamageCalculator(){

            @NotNull
            public Optional<Float> getBlockExplosionResistance(@NotNull Explosion explosion, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluid) {
                Optional<Float> def = super.getBlockExplosionResistance(explosion, world, pos, state, fluid);
                Optional<Float> ovr = BlockExplodeAction.this.indestructible.map(x -> x.test(level, pos)).filter(x -> x).map(x -> Float.valueOf(100.0f));
                return ovr.isPresent() ? (def.isPresent() ? (def.get().floatValue() > ovr.get().floatValue() ? def : ovr) : ovr) : def;
            }
        };
        level.explode(null, level.damageSources().explosion(null, null), calculator, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, this.power, this.createFire, Level.ExplosionInteraction.MOB);
    }

    public static enum DestructionType implements StringRepresentable
    {
        NONE(Explosion.BlockInteraction.KEEP),
        BREAK(Explosion.BlockInteraction.DESTROY_WITH_DECAY),
        DESTROY(Explosion.BlockInteraction.DESTROY);

        public static final Codec<DestructionType> CODEC;
        private final Explosion.BlockInteraction interaction;

        private DestructionType(Explosion.BlockInteraction interaction) {
            this.interaction = interaction;
        }

        public Explosion.BlockInteraction getInteraction() {
            return this.interaction;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(DestructionType::values);
        }
    }
}

