/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.block;

import com.iafenvoy.origins.data.action.BlockAction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public record BonemealAction(boolean effect) implements BlockAction
{
    public static final MapCodec<BonemealAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("effect", (Object)true).forGetter(BonemealAction::effect)).apply((Applicative)i, BonemealAction::new));

    @Override
    @NotNull
    public MapCodec<? extends BlockAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction) {
        if (BoneMealItem.growCrop((ItemStack)ItemStack.EMPTY, (Level)level, (BlockPos)pos)) {
            if (this.effect && !level.isClientSide) {
                level.globalLevelEvent(1505, pos, 0);
            }
        } else {
            BlockState blockState = level.getBlockState(pos);
            boolean bl = blockState.isFaceSturdy((BlockGetter)level, pos, direction);
            if (bl && BoneMealItem.growWaterPlant((ItemStack)ItemStack.EMPTY, (Level)level, (BlockPos)pos.relative(direction), (Direction)direction) && this.effect && !level.isClientSide) {
                level.globalLevelEvent(1505, pos.relative(direction), 0);
            }
        }
    }
}

