/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.block;

import com.iafenvoy.origins.data.action.BlockAction;
import com.iafenvoy.origins.data.action.EntityAction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record SpawnEntityAction(EntityType<?> entityType, Optional<CompoundTag> tag, EntityAction entityAction) implements BlockAction
{
    public static final MapCodec<SpawnEntityAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity_type").forGetter(SpawnEntityAction::entityType), (App)CompoundTag.CODEC.optionalFieldOf("tag").forGetter(SpawnEntityAction::tag), (App)EntityAction.optionalCodec("entity_action").forGetter(SpawnEntityAction::entityAction)).apply((Applicative)i, SpawnEntityAction::new));

    @Override
    @NotNull
    public MapCodec<? extends BlockAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction) {
        ServerLevel serverLevel;
        Entity entity;
        if (level instanceof ServerLevel && (entity = this.entityType.spawn(serverLevel = (ServerLevel)level, x -> this.tag.ifPresent(arg_0 -> ((Entity)x).load(arg_0)), pos, MobSpawnType.MOB_SUMMONED, false, false)) != null) {
            this.entityAction.execute(entity);
        }
    }
}

