/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.block.meta;

import com.iafenvoy.origins.data.action.BlockAction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record BlockChanceAction(BlockAction action, float chance, BlockAction failAction) implements BlockAction
{
    public static final MapCodec<BlockChanceAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BlockAction.CODEC.fieldOf("action").forGetter(BlockChanceAction::action), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(BlockChanceAction::chance), (App)BlockAction.optionalCodec("fail_action").forGetter(BlockChanceAction::failAction)).apply((Applicative)i, BlockChanceAction::new));

    @Override
    @NotNull
    public MapCodec<? extends BlockAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction) {
        if (Math.random() < (double)this.chance) {
            this.action.execute(level, pos, direction);
        } else {
            this.failAction.execute(level, pos, direction);
        }
    }
}

