/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.block.meta;

import com.iafenvoy.origins.data.action.BlockAction;
import com.iafenvoy.origins.util.WeightedRandomSelector;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record BlockChoiceAction(List<WeightedActionHolder> actions) implements BlockAction
{
    public static final MapCodec<BlockChoiceAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)WeightedActionHolder.CODEC.listOf().fieldOf("actions").forGetter(BlockChoiceAction::actions)).apply((Applicative)i, BlockChoiceAction::new));

    @Override
    @NotNull
    public MapCodec<? extends BlockAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction) {
        WeightedActionHolder holder = WeightedRandomSelector.selectRandomByWeight(this.actions);
        if (holder != null) {
            holder.element.execute(level, pos, direction);
        }
    }

    private record WeightedActionHolder(BlockAction element, int weight) implements WeightedRandomSelector.WeightGetter
    {
        public static final Codec<WeightedActionHolder> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockAction.CODEC.fieldOf("element").forGetter(WeightedActionHolder::element), (App)Codec.INT.optionalFieldOf("weight", (Object)0).forGetter(WeightedActionHolder::weight)).apply((Applicative)i, WeightedActionHolder::new));
    }
}

