/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.block.meta;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.origins.data.action.BlockAction;
import com.iafenvoy.origins.data.condition.BlockCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record BlockRegionApplyAction(int radius, Shape shape, BlockAction blockAction, BlockCondition blockCondition) implements BlockAction
{
    public static final MapCodec<BlockRegionApplyAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.INT.optionalFieldOf("radius", (Object)16).forGetter(BlockRegionApplyAction::radius), (App)Shape.CODEC.optionalFieldOf("shape", (Object)Shape.CUBE).forGetter(BlockRegionApplyAction::shape), (App)BlockAction.CODEC.fieldOf("block_action").forGetter(BlockRegionApplyAction::blockAction), (App)BlockCondition.optionalCodec("block_condition").forGetter(BlockRegionApplyAction::blockCondition)).apply((Applicative)i, BlockRegionApplyAction::new));

    @Override
    @NotNull
    public MapCodec<? extends BlockAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction) {
        List<BlockPos> positions = this.shape.getProcessor().apply(pos, this.radius);
        positions.removeIf(p -> !this.blockCondition.test(level, (BlockPos)p));
        positions.forEach(x -> this.blockAction.execute(level, (BlockPos)x, direction));
    }

    public static enum Shape implements StringRepresentable
    {
        CUBE((center, radius) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = -radius.intValue(); i <= radius; ++i) {
                for (int j = -radius.intValue(); j <= radius; ++j) {
                    for (int k = -radius.intValue(); k <= radius; ++k) {
                        builder.add((Object)center.offset(i, j, k));
                    }
                }
            }
            return builder.build();
        }),
        STAR((center, radius) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = -radius.intValue(); i <= radius; ++i) {
                for (int j = -radius.intValue(); j <= radius; ++j) {
                    for (int k = -radius.intValue(); k <= radius; ++k) {
                        if (Math.abs(i) + Math.abs(j) + Math.abs(k) > radius) continue;
                        builder.add((Object)center.offset(i, j, k));
                    }
                }
            }
            return builder.build();
        }),
        SPHERE((center, radius) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = -radius.intValue(); i <= radius; ++i) {
                for (int j = -radius.intValue(); j <= radius; ++j) {
                    for (int k = -radius.intValue(); k <= radius; ++k) {
                        if (i * i + j * j + k * k > radius * radius) continue;
                        builder.add((Object)center.offset(i, j, k));
                    }
                }
            }
            return builder.build();
        });

        public static final Codec<Shape> CODEC;
        private final BiFunction<BlockPos, Integer, List<BlockPos>> processor;

        private Shape(BiFunction<BlockPos, Integer, List<BlockPos>> processor) {
            this.processor = processor;
        }

        public BiFunction<BlockPos, Integer, List<BlockPos>> getProcessor() {
            return this.processor;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Shape::values);
        }
    }
}

