/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.entity;

import com.iafenvoy.origins.data.action.EntityAction;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public enum CraftingTableAction implements EntityAction
{
    INSTANCE;

    public static final MapCodec<CraftingTableAction> CODEC;
    private static final Component TITLE;

    @Override
    @NotNull
    public MapCodec<? extends EntityAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Entity source) {
        if (source instanceof Player) {
            Player player = (Player)source;
            player.openMenu((MenuProvider)new SimpleMenuProvider((syncId, inventory, p) -> new CraftingMenu(syncId, inventory, ContainerLevelAccess.create((Level)p.level(), (BlockPos)p.blockPosition())), TITLE));
            player.awardStat(Stats.INTERACT_WITH_CRAFTING_TABLE);
        }
    }

    static {
        CODEC = MapCodec.unit((Object)INSTANCE);
        TITLE = Component.translatable((String)"container.crafting");
    }
}

