/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.entity;

import com.iafenvoy.origins.data.action.EntityAction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public record FeedAction(int food, float saturation) implements EntityAction
{
    public static final MapCodec<FeedAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.INT.fieldOf("food").forGetter(FeedAction::food), (App)Codec.FLOAT.fieldOf("saturation").forGetter(FeedAction::saturation)).apply((Applicative)i, FeedAction::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Entity source) {
        if (source instanceof Player) {
            Player player = (Player)source;
            player.getFoodData().eat(this.food, this.saturation);
        }
    }
}

