/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.entity;

import com.iafenvoy.origins.data.action.EntityAction;
import com.iafenvoy.origins.data.action.ItemAction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record GiveItemAction(ItemStack stack, ItemAction itemAction, Optional<EquipmentSlot> preferredSlot) implements EntityAction
{
    public static final MapCodec<GiveItemAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ItemStack.CODEC.fieldOf("stack").forGetter(GiveItemAction::stack), (App)ItemAction.optionalCodec("item_action").forGetter(GiveItemAction::itemAction), (App)EquipmentSlot.CODEC.optionalFieldOf("preferred_slot").forGetter(GiveItemAction::preferredSlot)).apply((Applicative)i, GiveItemAction::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Entity source) {
        if (source instanceof Player) {
            Player player = (Player)source;
            ItemStack stack = this.stack.copy();
            this.itemAction.execute(player.level(), source, stack);
            if (this.preferredSlot.isPresent() && player.getItemBySlot(this.preferredSlot.get()).isEmpty()) {
                player.setItemSlot(this.preferredSlot.get(), stack);
            } else {
                player.getInventory().placeItemBackInInventory(stack);
            }
        }
    }
}

