/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.entity;

import com.iafenvoy.origins.data.action.EntityAction;
import com.iafenvoy.origins.util.codec.CombinedCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record SpawnEffectCloudAction(float radius, float radiusOnUse, int waitTime, List<MobEffectInstance> effect) implements EntityAction
{
    public static final MapCodec<SpawnEffectCloudAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.FLOAT.optionalFieldOf("radius", (Object)Float.valueOf(3.0f)).forGetter(SpawnEffectCloudAction::radius), (App)Codec.FLOAT.optionalFieldOf("radius_on_use", (Object)Float.valueOf(-0.5f)).forGetter(SpawnEffectCloudAction::radiusOnUse), (App)Codec.INT.optionalFieldOf("wait_time", (Object)10).forGetter(SpawnEffectCloudAction::waitTime), (App)CombinedCodecs.MOB_EFFECT_INSTANCE.optionalFieldOf("effect", List.of()).forGetter(SpawnEffectCloudAction::effect)).apply((Applicative)i, SpawnEffectCloudAction::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Entity source) {
        Level level = source.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType.AREA_EFFECT_CLOUD.spawn(serverLevel, c -> {
                c.setRadius(this.radius);
                c.setRadiusOnUse(this.radiusOnUse);
                c.setWaitTime(this.waitTime);
                this.effect.stream().map(MobEffectInstance::new).forEach(arg_0 -> ((AreaEffectCloud)c).addEffect(arg_0));
            }, source.blockPosition(), MobSpawnType.MOB_SUMMONED, false, false);
        }
    }
}

