/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.entity;

import com.iafenvoy.origins.data.action.BiEntityAction;
import com.iafenvoy.origins.data.action.EntityAction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record SpawnEntityAction(EntityType<?> entityType, Optional<CompoundTag> tag, EntityAction entityAction, BiEntityAction biEntityAction) implements EntityAction
{
    public static final MapCodec<SpawnEntityAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity_type").forGetter(SpawnEntityAction::entityType), (App)CompoundTag.CODEC.optionalFieldOf("tag").forGetter(SpawnEntityAction::tag), (App)EntityAction.optionalCodec("entity_action").forGetter(SpawnEntityAction::entityAction), (App)BiEntityAction.optionalCodec("bientity_action").forGetter(SpawnEntityAction::biEntityAction)).apply((Applicative)i, SpawnEntityAction::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Entity source) {
        Level level = source.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.entityType.spawn(serverLevel, c -> {
                this.tag.ifPresent(arg_0 -> ((Entity)c).load(arg_0));
                this.entityAction.execute((Entity)c);
                this.biEntityAction.execute(source, (Entity)c);
            }, source.blockPosition(), MobSpawnType.MOB_SUMMONED, false, false);
        }
    }
}

