/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.entity;

import com.iafenvoy.origins.data.action.EntityAction;
import com.iafenvoy.origins.data.condition.BiEntityCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record SpawnParticlesAction(ParticleType<?> particle, BiEntityCondition biEntityCondition, int count, float speed, boolean force, Vec3 spread, float offsetX, float offsetY, float offsetZ) implements EntityAction
{
    public static final MapCodec<SpawnParticlesAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.PARTICLE_TYPE.byNameCodec().fieldOf("particle").forGetter(SpawnParticlesAction::particle), (App)BiEntityCondition.optionalCodec("bientity_condition").forGetter(SpawnParticlesAction::biEntityCondition), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("count").forGetter(SpawnParticlesAction::count), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(0.0f)).forGetter(SpawnParticlesAction::speed), (App)Codec.BOOL.optionalFieldOf("force", (Object)false).forGetter(SpawnParticlesAction::force), (App)Vec3.CODEC.optionalFieldOf("spread", (Object)new Vec3(0.5, 0.5, 0.5)).forGetter(SpawnParticlesAction::spread), (App)Codec.FLOAT.optionalFieldOf("offset_x", (Object)Float.valueOf(0.0f)).forGetter(SpawnParticlesAction::offsetX), (App)Codec.FLOAT.optionalFieldOf("offset_y", (Object)Float.valueOf(0.5f)).forGetter(SpawnParticlesAction::offsetY), (App)Codec.FLOAT.optionalFieldOf("offset_z", (Object)Float.valueOf(0.0f)).forGetter(SpawnParticlesAction::offsetZ)).apply((Applicative)i, SpawnParticlesAction::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Entity source) {
        Level level = source.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 delta = this.spread.multiply((double)source.getBbWidth(), (double)source.getEyeHeight(source.getPose()), (double)source.getBbWidth());
            Vec3 pos = source.position().add((double)this.offsetX, (double)this.offsetY, (double)this.offsetZ);
            ParticleType<?> particleType = this.particle;
            if (particleType instanceof ParticleOptions) {
                ParticleOptions options = (ParticleOptions)particleType;
                for (ServerPlayer player : serverLevel.players()) {
                    if (!this.biEntityCondition.test(source, (Entity)player)) continue;
                    serverLevel.sendParticles(player, options, this.force, pos.x, pos.y, pos.z, this.count, delta.x, delta.y, delta.z, (double)this.speed);
                }
            }
        }
    }
}

