/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.entity.meta;

import com.iafenvoy.origins.data.action.EntityAction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public record EntityChanceAction(EntityAction action, float chance, EntityAction failAction) implements EntityAction
{
    public static final MapCodec<EntityChanceAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)EntityAction.CODEC.fieldOf("action").forGetter(EntityChanceAction::action), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(EntityChanceAction::chance), (App)EntityAction.optionalCodec("fail_action").forGetter(EntityChanceAction::failAction)).apply((Applicative)i, EntityChanceAction::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Entity source) {
        if (Math.random() < (double)this.chance) {
            this.action.execute(source);
        } else {
            this.failAction.execute(source);
        }
    }
}

