/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.entity.meta;

import com.iafenvoy.origins.data.action.EntityAction;
import com.iafenvoy.origins.util.WeightedRandomSelector;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public record EntityChoiceAction(List<WeightedActionHolder> actions) implements EntityAction
{
    public static final MapCodec<EntityChoiceAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)WeightedActionHolder.CODEC.listOf().fieldOf("actions").forGetter(EntityChoiceAction::actions)).apply((Applicative)i, EntityChoiceAction::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Entity source) {
        WeightedActionHolder holder = WeightedRandomSelector.selectRandomByWeight(this.actions);
        if (holder != null) {
            holder.element.execute(source);
        }
    }

    private record WeightedActionHolder(EntityAction element, int weight) implements WeightedRandomSelector.WeightGetter
    {
        public static final Codec<WeightedActionHolder> CODEC = RecordCodecBuilder.create(i -> i.group((App)EntityAction.CODEC.fieldOf("element").forGetter(WeightedActionHolder::element), (App)Codec.INT.optionalFieldOf("weight", (Object)0).forGetter(WeightedActionHolder::weight)).apply((Applicative)i, WeightedActionHolder::new));
    }
}

