/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.entity.meta;

import com.iafenvoy.origins.data.action.BiEntityAction;
import com.iafenvoy.origins.data.action.EntityAction;
import com.iafenvoy.origins.data.condition.BiEntityCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public record EntityRegionApplyAction(double radius, Shape shape, BiEntityAction biEntityAction, BiEntityCondition biEntityCondition, boolean includeActor) implements EntityAction
{
    public static final MapCodec<EntityRegionApplyAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.DOUBLE.optionalFieldOf("radius", (Object)16.0).forGetter(EntityRegionApplyAction::radius), (App)Shape.CODEC.optionalFieldOf("shape", (Object)Shape.CUBE).forGetter(EntityRegionApplyAction::shape), (App)BiEntityAction.CODEC.fieldOf("bientity_action").forGetter(EntityRegionApplyAction::biEntityAction), (App)BiEntityCondition.optionalCodec("bientity_condition").forGetter(EntityRegionApplyAction::biEntityCondition), (App)Codec.BOOL.optionalFieldOf("includeActor", (Object)false).forGetter(EntityRegionApplyAction::includeActor)).apply((Applicative)i, EntityRegionApplyAction::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Entity source) {
        for (Entity target : (List)this.shape.getProcessor().apply((Object)source.level(), (Object)source.position(), (Object)this.radius)) {
            if (target == source && !this.includeActor || !this.biEntityCondition.test(source, target)) continue;
            this.biEntityAction.execute(source, target);
        }
    }

    public static enum Shape implements StringRepresentable
    {
        CUBE((TriFunction<Level, Vec3, Double, List<Entity>>)((TriFunction)(level, center, radius) -> level.getEntitiesOfClass(Entity.class, Shape.createArea(center, radius)))),
        STAR((TriFunction<Level, Vec3, Double, List<Entity>>)((TriFunction)(level, center, radius) -> level.getEntitiesOfClass(Entity.class, Shape.createArea(center, radius), EntitySelector.NO_SPECTATORS.and(entity -> Math.abs(entity.getX() - center.x) + Math.abs(entity.getY() - center.y) + Math.abs(entity.getZ() - center.z) <= radius)))),
        SPHERE((TriFunction<Level, Vec3, Double, List<Entity>>)((TriFunction)(level, center, radius) -> level.getEntitiesOfClass(Entity.class, Shape.createArea(center, radius), EntitySelector.NO_SPECTATORS.and(entity -> entity.distanceToSqr(center) <= radius * radius))));

        public static final Codec<Shape> CODEC;
        private final TriFunction<Level, Vec3, Double, List<Entity>> processor;

        private Shape(TriFunction<Level, Vec3, Double, List<Entity>> processor) {
            this.processor = processor;
        }

        public TriFunction<Level, Vec3, Double, List<Entity>> getProcessor() {
            return this.processor;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        private static AABB createArea(Vec3 pos, double r) {
            return new AABB(pos.subtract(r, r, r), pos.add(r, r, r));
        }

        static {
            CODEC = StringRepresentable.fromEnum(Shape::values);
        }
    }
}

