/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.item;

import com.iafenvoy.origins.data.action.ItemAction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ItemDamageAction(int amount, boolean ignoreUnbreaking) implements ItemAction
{
    public static final MapCodec<ItemDamageAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(ItemDamageAction::amount), (App)Codec.BOOL.optionalFieldOf("ignore_unbreaking", (Object)false).forGetter(ItemDamageAction::ignoreUnbreaking)).apply((Applicative)i, ItemDamageAction::new));

    @Override
    @NotNull
    public MapCodec<? extends ItemAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Level level, @NotNull Entity source, @NotNull ItemStack stack) {
        if (this.ignoreUnbreaking) {
            stack.setDamageValue(stack.getDamageValue() - this.amount);
        } else if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            stack.hurtAndBreak(this.amount, serverLevel, null, item -> {});
        }
    }
}

