/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.item.meta;

import com.iafenvoy.origins.data.action.ItemAction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ItemChanceAction(ItemAction action, float chance, ItemAction failAction) implements ItemAction
{
    public static final MapCodec<ItemChanceAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ItemAction.CODEC.fieldOf("action").forGetter(ItemChanceAction::action), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(ItemChanceAction::chance), (App)ItemAction.optionalCodec("fail_action").forGetter(ItemChanceAction::failAction)).apply((Applicative)i, ItemChanceAction::new));

    @Override
    @NotNull
    public MapCodec<? extends ItemAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Level level, @NotNull Entity source, @NotNull ItemStack stack) {
        if (Math.random() < (double)this.chance) {
            this.action.execute(level, source, stack);
        } else {
            this.failAction.execute(level, source, stack);
        }
    }
}

