/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.item.meta;

import com.iafenvoy.origins.data.action.ItemAction;
import com.iafenvoy.origins.util.WeightedRandomSelector;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ItemChoiceAction(List<WeightedActionHolder> actions) implements ItemAction
{
    public static final MapCodec<ItemChoiceAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)WeightedActionHolder.CODEC.listOf().fieldOf("actions").forGetter(ItemChoiceAction::actions)).apply((Applicative)i, ItemChoiceAction::new));

    @Override
    @NotNull
    public MapCodec<? extends ItemAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Level level, @NotNull Entity source, @NotNull ItemStack stack) {
        WeightedActionHolder holder = WeightedRandomSelector.selectRandomByWeight(this.actions);
        if (holder != null) {
            holder.element.execute(level, source, stack);
        }
    }

    private record WeightedActionHolder(ItemAction element, int weight) implements WeightedRandomSelector.WeightGetter
    {
        public static final Codec<WeightedActionHolder> CODEC = RecordCodecBuilder.create(i -> i.group((App)ItemAction.CODEC.fieldOf("element").forGetter(WeightedActionHolder::element), (App)Codec.INT.optionalFieldOf("weight", (Object)0).forGetter(WeightedActionHolder::weight)).apply((Applicative)i, WeightedActionHolder::new));
    }
}

