/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.action.builtin.item.meta;

import com.iafenvoy.origins.data.action.ItemAction;
import com.iafenvoy.origins.data.condition.ItemCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ItemIfElseListAction(List<ConditionedActionHolder> actions) implements ItemAction
{
    public static final MapCodec<ItemIfElseListAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ConditionedActionHolder.CODEC.listOf().fieldOf("actions").forGetter(ItemIfElseListAction::actions)).apply((Applicative)i, ItemIfElseListAction::new));

    @Override
    @NotNull
    public MapCodec<? extends ItemAction> codec() {
        return CODEC;
    }

    @Override
    public void execute(@NotNull Level level, @NotNull Entity source, @NotNull ItemStack stack) {
        for (ConditionedActionHolder holder : this.actions) {
            if (!holder.condition.test(level, stack)) continue;
            holder.action.execute(level, source, stack);
            break;
        }
    }

    private record ConditionedActionHolder(ItemCondition condition, ItemAction action) {
        public static final Codec<ConditionedActionHolder> CODEC = RecordCodecBuilder.create(i -> i.group((App)ItemCondition.CODEC.fieldOf("condition").forGetter(ConditionedActionHolder::condition), (App)ItemAction.CODEC.fieldOf("action").forGetter(ConditionedActionHolder::action)).apply((Applicative)i, ConditionedActionHolder::new));
    }
}

