/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.condition.builtin.block;

import com.iafenvoy.origins.data.condition.BlockCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record BlockEntityNbtCondition(CompoundTag nbt) implements BlockCondition
{
    public static final MapCodec<BlockEntityNbtCondition> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)CompoundTag.CODEC.fieldOf("nbt").forGetter(BlockEntityNbtCondition::nbt)).apply((Applicative)i, BlockEntityNbtCondition::new));

    @Override
    @NotNull
    public MapCodec<? extends BlockCondition> codec() {
        return CODEC;
    }

    @Override
    public boolean test(@NotNull Level level, @NotNull BlockPos pos) {
        CompoundTag nbt = new CompoundTag();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            nbt = blockEntity.getUpdateTag((HolderLookup.Provider)level.registryAccess());
        }
        return NbtUtils.compareNbt((Tag)this.nbt, (Tag)nbt, (boolean)true);
    }
}

