/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.condition.builtin.damage;

import com.iafenvoy.origins.data.condition.DamageCondition;
import com.iafenvoy.origins.data.condition.EntityCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public record ProjectileCondition(Optional<EntityType<?>> projectile, EntityCondition projectileCondition) implements DamageCondition
{
    public static final MapCodec<ProjectileCondition> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().optionalFieldOf("projectile").forGetter(ProjectileCondition::projectile), (App)EntityCondition.optionalCodec("projectile_condition").forGetter(ProjectileCondition::projectileCondition)).apply((Applicative)i, ProjectileCondition::new));

    @Override
    @NotNull
    public MapCodec<? extends DamageCondition> codec() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(@NotNull DamageSource source, float amount) {
        Entity entitySource = source.getEntity();
        if (!source.is(DamageTypeTags.IS_PROJECTILE)) return false;
        if (entitySource == null) return false;
        if (this.projectile.map(entitySource.getType()::equals).orElse(true) == false) return false;
        if (!this.projectileCondition.test(entitySource)) return false;
        return true;
    }
}

